/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.CredentialsProviderFactory;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.auth.SystemPropertiesCredentialsProvider;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFFE)
@Conditional(value={AliOssCondition.class})
public class AliOssService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(AliOssService.class);
    private static final String TYPE_ALI_OSS = "alioss";
    private static final String KEY_ENDPOINT = "endpoint";
    private static final String KEY_BUCKET = "bucket";
    private static final String KEY_CREDENTIAL_TYPE = "credential_type";
    private static final String KEY_AK = "ak";
    private static final String KEY_SK = "sk";
    private static final String KEY_TOKEN = "token";
    private OSS oss;
    private String bucket;
    private static final int DOWNLOAD_PART_SIZE = 10240;
    private static final String NO_SUCH_KEY = "NoSuchKey";

    public void store(StoreRequest storeRequest) throws IOException {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, AliOssService.parseFileName(storeRequest.getFileLocation()), storeRequest.getLocalFile(), objectMetadata);
        this.oss.putObject(putObjectRequest);
    }

    public void download(DownloadRequest downloadRequest) throws IOException {
        FileLocation dfl = downloadRequest.getFileLocation();
        DownloadFileRequest downloadFileRequest = new DownloadFileRequest(this.bucket, AliOssService.parseFileName(dfl), downloadRequest.getTarget().getAbsolutePath(), 10240L);
        try {
            FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
            this.oss.downloadFile(downloadFileRequest);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) throws IOException {
        try {
            ObjectMetadata objectMetadata = this.oss.getObjectMetadata(this.bucket, AliOssService.parseFileName(fileLocation));
            return Optional.ofNullable(objectMetadata).map(ossM -> {
                HashMap metaInfo = Maps.newHashMap();
                metaInfo.putAll(ossM.getRawMetadata());
                if (ossM.getUserMetadata() != null) {
                    metaInfo.putAll(ossM.getUserMetadata());
                }
                return new FileMeta().setLastModifiedTime(ossM.getLastModified()).setLength(ossM.getContentLength()).setMetaInfo((Map)metaInfo);
            });
        }
        catch (OSSException oe) {
            String errorCode = oe.getErrorCode();
            if (NO_SUCH_KEY.equalsIgnoreCase(errorCode)) {
                return Optional.empty();
            }
            ExceptionUtils.rethrow((Throwable)oe);
            return Optional.empty();
        }
    }

    private static String parseFileName(FileLocation fileLocation) {
        return String.format("%s/%s", fileLocation.getBucket(), fileLocation.getName());
    }

    void initOssClient(String endpoint, String bucket, String mode, String ak, String sk, String token) throws Exception {
        SystemPropertiesCredentialsProvider credentialsProvider;
        log.info("[AliOssService] init OSS by config: endpoint={},bucket={},credentialType={},ak={},sk={},token={}", new Object[]{endpoint, bucket, mode, ak, sk, token});
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            throw new IllegalArgumentException("'oms.storage.dfs.alioss.bucket' can't be empty, please creat a bucket in aliyun oss console then config it to powerjob");
        }
        this.bucket = bucket;
        CredentialType credentialType = CredentialType.parse(mode);
        switch (credentialType) {
            case PWD: {
                credentialsProvider = new DefaultCredentialProvider(ak, sk, token);
                break;
            }
            case SYSTEM_PROPERTY: {
                credentialsProvider = CredentialsProviderFactory.newSystemPropertiesCredentialsProvider();
                break;
            }
            default: {
                credentialsProvider = CredentialsProviderFactory.newEnvironmentVariableCredentialsProvider();
            }
        }
        this.oss = new OSSClientBuilder().build(endpoint, (CredentialsProvider)credentialsProvider);
        log.info("[AliOssService] initialize successfully, THIS_WILL_BE_THE_STORAGE_LAYER.");
    }

    public void cleanExpiredFiles(String bucket, int days) {
    }

    public void destroy() throws Exception {
        this.oss.shutdown();
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        Environment environment = applicationContext.getEnvironment();
        String endpoint = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_ENDPOINT);
        String bkt = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_BUCKET);
        String ct = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_CREDENTIAL_TYPE);
        String ak = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_AK);
        String sk = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_SK);
        String token = AliOssService.fetchProperty(environment, TYPE_ALI_OSS, KEY_TOKEN);
        try {
            this.initOssClient(endpoint, bkt, ct, ak, sk, token);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static class AliOssCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{"oms.storage.dfs.alioss.endpoint"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }

    static enum CredentialType {
        ENV("env"),
        SYSTEM_PROPERTY("sys"),
        PWD("pwd");

        private final String code;

        public static CredentialType parse(String mode) {
            for (CredentialType credentialType : CredentialType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)credentialType.code, (CharSequence)mode)) continue;
                return credentialType;
            }
            return PWD;
        }

        public String getCode() {
            return this.code;
        }

        private CredentialType(String code) {
            this.code = code;
        }
    }
}

