/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.monitor;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;
import tech.powerjob.server.common.utils.AOPUtils;
import tech.powerjob.server.monitor.Event;
import tech.powerjob.server.monitor.MonitorService;
import tech.powerjob.server.monitor.events.db.DatabaseEvent;
import tech.powerjob.server.monitor.events.db.DatabaseType;

@Aspect
@Component
public class DatabaseMonitorAspect {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMonitorAspect.class);
    private final MonitorService monitorService;

    @Around(value="execution(* tech.powerjob.server.persistence.remote.repository..*.*(..))")
    public Object monitorCoreDB(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.wrapperMonitor(joinPoint, DatabaseType.CORE);
    }

    @Around(value="execution(* tech.powerjob.server.persistence.local..*.*(..))")
    public Object monitorLocalDB(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.wrapperMonitor(joinPoint, DatabaseType.LOCAL);
    }

    private Object wrapperMonitor(ProceedingJoinPoint point, DatabaseType type) throws Throwable {
        String classNameMini = AOPUtils.parseRealClassName((JoinPoint)point);
        String methodName = point.getSignature().getName();
        DatabaseEvent event = new DatabaseEvent().setType(type).setServiceName(classNameMini).setMethodName(methodName).setStatus(DatabaseEvent.Status.SUCCESS);
        long startTs = System.currentTimeMillis();
        try {
            Object ret = point.proceed();
            event.setRows(DatabaseMonitorAspect.parseEffectRows(ret));
            Object object = ret;
            return object;
        }
        catch (Throwable t) {
            event.setErrorMsg(t.getClass().getSimpleName()).setStatus(DatabaseEvent.Status.FAILED);
            throw t;
        }
        finally {
            long cost = System.currentTimeMillis() - startTs;
            this.monitorService.monitor((Event)event.setCost(cost));
        }
    }

    private static Integer parseEffectRows(Object ret) {
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        if (ret instanceof Optional) {
            return ((Optional)ret).isPresent() ? 1 : 0;
        }
        if (ret instanceof Collection) {
            return ((Collection)ret).size();
        }
        if (ret instanceof Slice) {
            return ((Slice)ret).getSize();
        }
        if (ret instanceof Stream) {
            return null;
        }
        return ret == null ? 0 : 1;
    }

    public DatabaseMonitorAspect(MonitorService monitorService) {
        this.monitorService = monitorService;
    }
}

