/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.core.scheduler.auxiliary.TimingStrategyHandler;

@Service
public class TimingStrategyService {
    private static final Logger log = LoggerFactory.getLogger(TimingStrategyService.class);
    private static final int NEXT_N_TIMES = 5;
    private static final List<String> TIPS = Collections.singletonList("It is valid, but has not trigger time list!");
    private final Map<TimeExpressionType, TimingStrategyHandler> strategyContainer = new EnumMap<TimeExpressionType, TimingStrategyHandler>(TimeExpressionType.class);

    public TimingStrategyService(List<TimingStrategyHandler> timingStrategyHandlers) {
        for (TimingStrategyHandler timingStrategyHandler : timingStrategyHandlers) {
            this.strategyContainer.put(timingStrategyHandler.supportType(), timingStrategyHandler);
        }
    }

    public List<String> calculateNextTriggerTimes(TimeExpressionType timeExpressionType, String timeExpression, Long startTime, Long endTime) {
        TimingStrategyHandler timingStrategyHandler = this.getHandler(timeExpressionType);
        ArrayList<Long> triggerTimeList = new ArrayList<Long>(5);
        Long nextTriggerTime = System.currentTimeMillis();
        while ((nextTriggerTime = timingStrategyHandler.calculateNextTriggerTime(nextTriggerTime, timeExpression, startTime, endTime)) != null) {
            triggerTimeList.add(nextTriggerTime);
            if (triggerTimeList.size() < 5) continue;
        }
        if (triggerTimeList.isEmpty()) {
            return TIPS;
        }
        return triggerTimeList.stream().map(t -> DateFormatUtils.format((long)t, (String)"yyyy-MM-dd HH:mm:ss")).collect(Collectors.toList());
    }

    public Long calculateNextTriggerTime(Long preTriggerTime, TimeExpressionType timeExpressionType, String timeExpression, Long startTime, Long endTime) {
        if (preTriggerTime == null || preTriggerTime < System.currentTimeMillis()) {
            preTriggerTime = System.currentTimeMillis();
        }
        return this.getHandler(timeExpressionType).calculateNextTriggerTime(preTriggerTime, timeExpression, startTime, endTime);
    }

    public Long calculateNextTriggerTimeWithInspection(TimeExpressionType timeExpressionType, String timeExpression, Long startTime, Long endTime) {
        Long nextTriggerTime = this.calculateNextTriggerTime(null, timeExpressionType, timeExpression, startTime, endTime);
        if (TimeExpressionType.INSPECT_TYPES.contains(timeExpressionType.getV()) && nextTriggerTime == null) {
            throw new PowerJobException("time expression is out of date: " + timeExpression);
        }
        return nextTriggerTime;
    }

    public void validate(TimeExpressionType timeExpressionType, String timeExpression, Long startTime, Long endTime) {
        if (endTime != null) {
            if (endTime <= System.currentTimeMillis()) {
                throw new PowerJobException("lifecycle is out of date!");
            }
            if (startTime != null && startTime > endTime) {
                throw new PowerJobException("lifecycle is invalid! start time must earlier then end time.");
            }
        }
        this.getHandler(timeExpressionType).validate(timeExpression);
    }

    private TimingStrategyHandler getHandler(TimeExpressionType timeExpressionType) {
        TimingStrategyHandler timingStrategyHandler = this.strategyContainer.get(timeExpressionType);
        if (timingStrategyHandler == null) {
            throw new PowerJobException("No matching TimingStrategyHandler for this TimeExpressionType:" + timeExpressionType);
        }
        return timingStrategyHandler;
    }
}

