/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.timewheel.holder;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import tech.powerjob.server.common.timewheel.HashedWheelTimer;
import tech.powerjob.server.common.timewheel.Timer;
import tech.powerjob.server.common.timewheel.TimerFuture;
import tech.powerjob.server.common.timewheel.TimerTask;

public class InstanceTimeWheelService {
    private static final Map<Long, TimerFuture> CARGO = Maps.newConcurrentMap();
    private static final Timer TIMER = new HashedWheelTimer(1L, 4096, Runtime.getRuntime().availableProcessors() * 4);
    private static final Timer SLOW_TIMER = new HashedWheelTimer(10000L, 12, 0);
    private static final long MIN_INTERVAL_MS = 1000L;
    private static final long LONG_DELAY_THRESHOLD_MS = 60000L;

    public static void schedule(Long uniqueId, Long delayMS, TimerTask timerTask) {
        if (delayMS <= 60000L) {
            InstanceTimeWheelService.realSchedule(uniqueId, delayMS, timerTask);
            return;
        }
        long expectTriggerTime = System.currentTimeMillis() + delayMS;
        TimerFuture longDelayTask = SLOW_TIMER.schedule(() -> {
            CARGO.remove(uniqueId);
            InstanceTimeWheelService.realSchedule(uniqueId, expectTriggerTime - System.currentTimeMillis(), timerTask);
        }, delayMS - 60000L, TimeUnit.MILLISECONDS);
        CARGO.put(uniqueId, longDelayTask);
    }

    public static TimerFuture fetchTimerFuture(Long uniqueId) {
        return CARGO.get(uniqueId);
    }

    private static void realSchedule(Long uniqueId, Long delayMS, TimerTask timerTask) {
        TimerFuture timerFuture = TIMER.schedule(() -> {
            CARGO.remove(uniqueId);
            timerTask.run();
        }, delayMS, TimeUnit.MILLISECONDS);
        if (delayMS > 1000L) {
            CARGO.put(uniqueId, timerFuture);
        }
    }
}

