/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.spring.condition;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import tech.powerjob.common.utils.CollectionUtils;

public abstract class PropertyAndOneBeanCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(PropertyAndOneBeanCondition.class);

    protected abstract List<String> anyConfigKey();

    protected abstract Class<?> beanType();

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean anyCfgExist = this.checkAnyConfigExist(context);
        log.info("[PropertyAndOneBeanCondition] [{}] check any config exist result with keys={}: {}", new Object[]{this.thisName(), this.anyConfigKey(), anyCfgExist});
        if (!anyCfgExist) {
            return false;
        }
        Class<?> beanType = this.beanType();
        if (beanType == null) {
            return true;
        }
        boolean exist = this.checkBeanExist(context);
        log.info("[PropertyAndOneBeanCondition] [{}] bean of type[{}] exist check result: {}", new Object[]{this.thisName(), beanType.getSimpleName(), exist});
        if (exist) {
            log.info("[PropertyAndOneBeanCondition] [{}] bean of type[{}] already exist, skip load!", (Object)this.thisName(), (Object)beanType.getSimpleName());
            return false;
        }
        return true;
    }

    private boolean checkAnyConfigExist(ConditionContext context) {
        Environment environment = context.getEnvironment();
        List<String> keys = this.anyConfigKey();
        if (CollectionUtils.isEmpty(keys)) {
            return true;
        }
        for (String key : keys) {
            if (!StringUtils.isNotEmpty((CharSequence)environment.getProperty(key))) continue;
            return true;
        }
        return false;
    }

    private boolean checkBeanExist(ConditionContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory == null) {
            return false;
        }
        try {
            beanFactory.getBean(this.beanType());
            return true;
        }
        catch (NoSuchBeanDefinitionException ignore) {
            return false;
        }
    }

    private String thisName() {
        return this.getClass().getSimpleName();
    }
}

