/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedExecutionHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(RejectedExecutionHandlerFactory.class);
    private static final AtomicLong COUNTER = new AtomicLong();

    public static RejectedExecutionHandler newAbort(String source) {
        return (r, e) -> {
            log.error("[{}] ThreadPool[{}] overload, the task[{}] will be Abort, Maybe you need to adjust the ThreadPool config!", new Object[]{source, e, r});
            throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + source);
        };
    }

    public static RejectedExecutionHandler newDiscard(String source) {
        return (r, p) -> log.error("[{}] ThreadPool[{}] overload, the task[{}] will be Discard, Maybe you need to adjust the ThreadPool config!", new Object[]{source, p, r});
    }

    public static RejectedExecutionHandler newCallerRun(String source) {
        return (r, p) -> {
            log.error("[{}] ThreadPool[{}] overload, the task[{}] will run by caller thread, Maybe you need to adjust the ThreadPool config!", new Object[]{source, p, r});
            if (!p.isShutdown()) {
                r.run();
            }
        };
    }

    public static RejectedExecutionHandler newThreadRun(String source) {
        return (r, p) -> {
            log.error("[{}] ThreadPool[{}] overload, the task[{}] will run by a new thread!, Maybe you need to adjust the ThreadPool config!", new Object[]{source, p, r});
            if (!p.isShutdown()) {
                String threadName = source + "-T-" + COUNTER.getAndIncrement();
                log.info("[{}] create new thread[{}] to run job", (Object)source, (Object)threadName);
                new Thread(r, threadName).start();
            }
        };
    }
}

