/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SourceTableConfig;
import software.amazon.awssdk.services.glue.model.TargetTableConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntegrationTablePropertiesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateIntegrationTablePropertiesRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(UpdateIntegrationTablePropertiesRequest.getter(UpdateIntegrationTablePropertiesRequest::resourceArn)).setter(UpdateIntegrationTablePropertiesRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateIntegrationTablePropertiesRequest.getter(UpdateIntegrationTablePropertiesRequest::tableName)).setter(UpdateIntegrationTablePropertiesRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<SourceTableConfig> SOURCE_TABLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceTableConfig").getter(UpdateIntegrationTablePropertiesRequest.getter(UpdateIntegrationTablePropertiesRequest::sourceTableConfig)).setter(UpdateIntegrationTablePropertiesRequest.setter(Builder::sourceTableConfig)).constructor(SourceTableConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableConfig").build()}).build();
    private static final SdkField<TargetTableConfig> TARGET_TABLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTableConfig").getter(UpdateIntegrationTablePropertiesRequest.getter(UpdateIntegrationTablePropertiesRequest::targetTableConfig)).setter(UpdateIntegrationTablePropertiesRequest.setter(Builder::targetTableConfig)).constructor(TargetTableConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, TABLE_NAME_FIELD, SOURCE_TABLE_CONFIG_FIELD, TARGET_TABLE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIntegrationTablePropertiesRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String tableName;
    private final SourceTableConfig sourceTableConfig;
    private final TargetTableConfig targetTableConfig;

    private UpdateIntegrationTablePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tableName = builder.tableName;
        this.sourceTableConfig = builder.sourceTableConfig;
        this.targetTableConfig = builder.targetTableConfig;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final SourceTableConfig sourceTableConfig() {
        return this.sourceTableConfig;
    }

    public final TargetTableConfig targetTableConfig() {
        return this.targetTableConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationTablePropertiesRequest)) {
            return false;
        }
        UpdateIntegrationTablePropertiesRequest other = (UpdateIntegrationTablePropertiesRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.sourceTableConfig(), other.sourceTableConfig()) && Objects.equals(this.targetTableConfig(), other.targetTableConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntegrationTablePropertiesRequest").add("ResourceArn", (Object)this.resourceArn()).add("TableName", (Object)this.tableName()).add("SourceTableConfig", (Object)this.sourceTableConfig()).add("TargetTableConfig", (Object)this.targetTableConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "SourceTableConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceTableConfig()));
            }
            case "TargetTableConfig": {
                return Optional.ofNullable(clazz.cast(this.targetTableConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("SourceTableConfig", SOURCE_TABLE_CONFIG_FIELD);
        map.put("TargetTableConfig", TARGET_TABLE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationTablePropertiesRequest, T> g) {
        return obj -> g.apply((UpdateIntegrationTablePropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String tableName;
        private SourceTableConfig sourceTableConfig;
        private TargetTableConfig targetTableConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationTablePropertiesRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.tableName(model.tableName);
            this.sourceTableConfig(model.sourceTableConfig);
            this.targetTableConfig(model.targetTableConfig);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final SourceTableConfig.Builder getSourceTableConfig() {
            return this.sourceTableConfig != null ? this.sourceTableConfig.toBuilder() : null;
        }

        public final void setSourceTableConfig(SourceTableConfig.BuilderImpl sourceTableConfig) {
            this.sourceTableConfig = sourceTableConfig != null ? sourceTableConfig.build() : null;
        }

        @Override
        public final Builder sourceTableConfig(SourceTableConfig sourceTableConfig) {
            this.sourceTableConfig = sourceTableConfig;
            return this;
        }

        public final TargetTableConfig.Builder getTargetTableConfig() {
            return this.targetTableConfig != null ? this.targetTableConfig.toBuilder() : null;
        }

        public final void setTargetTableConfig(TargetTableConfig.BuilderImpl targetTableConfig) {
            this.targetTableConfig = targetTableConfig != null ? targetTableConfig.build() : null;
        }

        @Override
        public final Builder targetTableConfig(TargetTableConfig targetTableConfig) {
            this.targetTableConfig = targetTableConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntegrationTablePropertiesRequest build() {
            return new UpdateIntegrationTablePropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntegrationTablePropertiesRequest> {
        public Builder resourceArn(String var1);

        public Builder tableName(String var1);

        public Builder sourceTableConfig(SourceTableConfig var1);

        default public Builder sourceTableConfig(Consumer<SourceTableConfig.Builder> sourceTableConfig) {
            return this.sourceTableConfig((SourceTableConfig)((SourceTableConfig.Builder)SourceTableConfig.builder().applyMutation(sourceTableConfig)).build());
        }

        public Builder targetTableConfig(TargetTableConfig var1);

        default public Builder targetTableConfig(Consumer<TargetTableConfig.Builder> targetTableConfig) {
            return this.targetTableConfig((TargetTableConfig)((TargetTableConfig.Builder)TargetTableConfig.builder().applyMutation(targetTableConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

