/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GluePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GluePolicy> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyInJson").getter(GluePolicy.getter(GluePolicy::policyInJson)).setter(GluePolicy.setter(Builder::policyInJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()}).build();
    private static final SdkField<String> POLICY_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyHash").getter(GluePolicy.getter(GluePolicy::policyHash)).setter(GluePolicy.setter(Builder::policyHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHash").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(GluePolicy.getter(GluePolicy::createTime)).setter(GluePolicy.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(GluePolicy.getter(GluePolicy::updateTime)).setter(GluePolicy.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD, POLICY_HASH_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GluePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyInJson;
    private final String policyHash;
    private final Instant createTime;
    private final Instant updateTime;

    private GluePolicy(BuilderImpl builder) {
        this.policyInJson = builder.policyInJson;
        this.policyHash = builder.policyHash;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String policyInJson() {
        return this.policyInJson;
    }

    public final String policyHash() {
        return this.policyHash;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GluePolicy)) {
            return false;
        }
        GluePolicy other = (GluePolicy)obj;
        return Objects.equals(this.policyInJson(), other.policyInJson()) && Objects.equals(this.policyHash(), other.policyHash()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GluePolicy").add("PolicyInJson", (Object)this.policyInJson()).add("PolicyHash", (Object)this.policyHash()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyInJson": {
                return Optional.ofNullable(clazz.cast(this.policyInJson()));
            }
            case "PolicyHash": {
                return Optional.ofNullable(clazz.cast(this.policyHash()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyInJson", POLICY_IN_JSON_FIELD);
        map.put("PolicyHash", POLICY_HASH_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GluePolicy, T> g) {
        return obj -> g.apply((GluePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyInJson;
        private String policyHash;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GluePolicy model) {
            this.policyInJson(model.policyInJson);
            this.policyHash(model.policyHash);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getPolicyInJson() {
            return this.policyInJson;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final String getPolicyHash() {
            return this.policyHash;
        }

        public final void setPolicyHash(String policyHash) {
            this.policyHash = policyHash;
        }

        @Override
        public final Builder policyHash(String policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public GluePolicy build() {
            return new GluePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GluePolicy> {
        public Builder policyInJson(String var1);

        public Builder policyHash(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

