/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateTableRequest> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeDefinitions").getter(UpdateTableRequest.getter(UpdateTableRequest::attributeDefinitions)).setter(UpdateTableRequest.setter(Builder::attributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateTableRequest.getter(UpdateTableRequest::tableName)).setter(UpdateTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingMode").getter(UpdateTableRequest.getter(UpdateTableRequest::billingModeAsString)).setter(UpdateTableRequest.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(UpdateTableRequest.getter(UpdateTableRequest::provisionedThroughput)).setter(UpdateTableRequest.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<List<GlobalSecondaryIndexUpdate>> GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexUpdates").getter(UpdateTableRequest.getter(UpdateTableRequest::globalSecondaryIndexUpdates)).setter(UpdateTableRequest.setter(Builder::globalSecondaryIndexUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndexUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSpecification").getter(UpdateTableRequest.getter(UpdateTableRequest::streamSpecification)).setter(UpdateTableRequest.setter(Builder::streamSpecification)).constructor(StreamSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build()}).build();
    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSESpecification").getter(UpdateTableRequest.getter(UpdateTableRequest::sseSpecification)).setter(UpdateTableRequest.setter(Builder::sseSpecification)).constructor(SSESpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()}).build();
    private static final SdkField<List<ReplicationGroupUpdate>> REPLICA_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaUpdates").getter(UpdateTableRequest.getter(UpdateTableRequest::replicaUpdates)).setter(UpdateTableRequest.setter(Builder::replicaUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationGroupUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableClass").getter(UpdateTableRequest.getter(UpdateTableRequest::tableClassAsString)).setter(UpdateTableRequest.setter(Builder::tableClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD, TABLE_NAME_FIELD, BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, GLOBAL_SECONDARY_INDEX_UPDATES_FIELD, STREAM_SPECIFICATION_FIELD, SSE_SPECIFICATION_FIELD, REPLICA_UPDATES_FIELD, TABLE_CLASS_FIELD));
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final String billingMode;
    private final ProvisionedThroughput provisionedThroughput;
    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;
    private final StreamSpecification streamSpecification;
    private final SSESpecification sseSpecification;
    private final List<ReplicationGroupUpdate> replicaUpdates;
    private final String tableClass;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
        this.sseSpecification = builder.sseSpecification;
        this.replicaUpdates = builder.replicaUpdates;
        this.tableClass = builder.tableClass;
    }

    public final boolean hasAttributeDefinitions() {
        return this.attributeDefinitions != null && !(this.attributeDefinitions instanceof SdkAutoConstructList);
    }

    public final List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public final String billingModeAsString() {
        return this.billingMode;
    }

    public final ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final boolean hasGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates != null && !(this.globalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    public final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public final StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public final SSESpecification sseSpecification() {
        return this.sseSpecification;
    }

    public final boolean hasReplicaUpdates() {
        return this.replicaUpdates != null && !(this.replicaUpdates instanceof SdkAutoConstructList);
    }

    public final List<ReplicationGroupUpdate> replicaUpdates() {
        return this.replicaUpdates;
    }

    public final TableClass tableClass() {
        return TableClass.fromValue(this.tableClass);
    }

    public final String tableClassAsString() {
        return this.tableClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeDefinitions() ? this.attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexUpdates() ? this.globalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaUpdates() ? this.replicaUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)obj);
        return this.hasAttributeDefinitions() == other.hasAttributeDefinitions() && Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.billingModeAsString(), other.billingModeAsString()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && this.hasGlobalSecondaryIndexUpdates() == other.hasGlobalSecondaryIndexUpdates() && Objects.equals(this.globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates()) && Objects.equals(this.streamSpecification(), other.streamSpecification()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && this.hasReplicaUpdates() == other.hasReplicaUpdates() && Objects.equals(this.replicaUpdates(), other.replicaUpdates()) && Objects.equals(this.tableClassAsString(), other.tableClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableRequest").add("AttributeDefinitions", this.hasAttributeDefinitions() ? this.attributeDefinitions() : null).add("TableName", (Object)this.tableName()).add("BillingMode", (Object)this.billingModeAsString()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("GlobalSecondaryIndexUpdates", this.hasGlobalSecondaryIndexUpdates() ? this.globalSecondaryIndexUpdates() : null).add("StreamSpecification", (Object)this.streamSpecification()).add("SSESpecification", (Object)this.sseSpecification()).add("ReplicaUpdates", this.hasReplicaUpdates() ? this.replicaUpdates() : null).add("TableClass", (Object)this.tableClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinitions()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "GlobalSecondaryIndexUpdates": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexUpdates()));
            }
            case "StreamSpecification": {
                return Optional.ofNullable(clazz.cast(this.streamSpecification()));
            }
            case "SSESpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "ReplicaUpdates": {
                return Optional.ofNullable(clazz.cast(this.replicaUpdates()));
            }
            case "TableClass": {
                return Optional.ofNullable(clazz.cast(this.tableClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String tableName;
        private String billingMode;
        private ProvisionedThroughput provisionedThroughput;
        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates = DefaultSdkAutoConstructList.getInstance();
        private StreamSpecification streamSpecification;
        private SSESpecification sseSpecification;
        private List<ReplicationGroupUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();
        private String tableClass;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            this.attributeDefinitions(model.attributeDefinitions);
            this.tableName(model.tableName);
            this.billingMode(model.billingMode);
            this.provisionedThroughput(model.provisionedThroughput);
            this.globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            this.streamSpecification(model.streamSpecification);
            this.sseSpecification(model.sseSpecification);
            this.replicaUpdates(model.replicaUpdates);
            this.tableClass(model.tableClass);
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... attributeDefinitions) {
            this.attributeDefinitions(Stream.of(attributeDefinitions).map(c -> (AttributeDefinition)((AttributeDefinition.Builder)AttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final List<GlobalSecondaryIndexUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            List<GlobalSecondaryIndexUpdate.Builder> result = GlobalSecondaryIndexUpdateListCopier.copyToBuilder(this.globalSecondaryIndexUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copyFromBuilder(globalSecondaryIndexUpdates);
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexUpdate.Builder> ... globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates(Stream.of(globalSecondaryIndexUpdates).map(c -> (GlobalSecondaryIndexUpdate)((GlobalSecondaryIndexUpdate.Builder)GlobalSecondaryIndexUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final List<ReplicationGroupUpdate.Builder> getReplicaUpdates() {
            List<ReplicationGroupUpdate.Builder> result = ReplicationGroupUpdateListCopier.copyToBuilder(this.replicaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaUpdates(Collection<ReplicationGroupUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicationGroupUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicationGroupUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicationGroupUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicationGroupUpdate ... replicaUpdates) {
            this.replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicationGroupUpdate.Builder> ... replicaUpdates) {
            this.replicaUpdates(Stream.of(replicaUpdates).map(c -> (ReplicationGroupUpdate)((ReplicationGroupUpdate.Builder)ReplicationGroupUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableClass() {
            return this.tableClass;
        }

        public final void setTableClass(String tableClass) {
            this.tableClass = tableClass;
        }

        @Override
        public final Builder tableClass(String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        @Override
        public final Builder tableClass(TableClass tableClass) {
            this.tableClass(tableClass == null ? null : tableClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableRequest> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... var1);

        public Builder tableName(String var1);

        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> var1);

        public Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... var1);

        public Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexUpdate.Builder> ... var1);

        public Builder streamSpecification(StreamSpecification var1);

        default public Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().applyMutation(streamSpecification)).build());
        }

        public Builder sseSpecification(SSESpecification var1);

        default public Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return this.sseSpecification((SSESpecification)((SSESpecification.Builder)SSESpecification.builder().applyMutation(sseSpecification)).build());
        }

        public Builder replicaUpdates(Collection<ReplicationGroupUpdate> var1);

        public Builder replicaUpdates(ReplicationGroupUpdate ... var1);

        public Builder replicaUpdates(Consumer<ReplicationGroupUpdate.Builder> ... var1);

        public Builder tableClass(String var1);

        public Builder tableClass(TableClass var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

