/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.dsql.DsqlAsyncClient;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.waiters.DefaultDsqlAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface DsqlAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(GetClusterRequest getClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(Consumer<GetClusterRequest.Builder> getClusterRequest) {
        return this.waitUntilClusterActive((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(Consumer<GetClusterRequest.Builder> getClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterActive((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(GetClusterRequest getClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(Consumer<GetClusterRequest.Builder> getClusterRequest) {
        return this.waitUntilClusterNotExists((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(Consumer<GetClusterRequest.Builder> getClusterRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilClusterNotExists((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultDsqlAsyncWaiter.builder();
    }

    public static DsqlAsyncWaiter create() {
        return DefaultDsqlAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(DsqlAsyncClient var1);

        public DsqlAsyncWaiter build();
    }
}

