/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public final class CustomObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader = null;

    public CustomObjectInputStream(InputStream stream, ClassLoader classLoader) throws IOException {
        super(stream);
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException, IOException {
        try {
            return Class.forName(classDesc.getName(), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            try {
                return super.resolveClass(classDesc);
            }
            catch (ClassNotFoundException e2) {
                throw e;
            }
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.classLoader.loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

