/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.UnsignedLong;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryStream;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class ClickHouseRowBinaryInputStream
implements Closeable {
    private final LittleEndianDataInputStream in;
    private final TimeZone timeZone;

    public ClickHouseRowBinaryInputStream(InputStream is, TimeZone timeZone, ClickHouseProperties properties) {
        this.in = new LittleEndianDataInputStream(is);
        this.timeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
    }

    public int readUnsignedLeb128() throws IOException {
        int read;
        int value = 0;
        int count = 0;
        do {
            read = this.in.readByte() & 0xFF;
            value |= (read & 0x7F) << count * 7;
        } while ((read & 0x80) == 128 && ++count < 5);
        if ((read & 0x80) == 128) {
            throw new IOException("invalid LEB128 sequence");
        }
        return value;
    }

    public void readBytes(byte[] bytes) throws IOException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int length) throws IOException {
        while (length > 0) {
            int read = this.in.read(bytes, offset, length);
            if (read == -1) {
                throw new EOFException();
            }
            offset += read;
            length -= read;
        }
    }

    public int readByte() throws IOException {
        return this.in.read();
    }

    public boolean readIsNull() throws IOException {
        int value = this.readByte();
        if (value == -1) {
            throw new EOFException();
        }
        this.validateInt(value, 0, 1, "nullable");
        return value != 0;
    }

    public String readString() throws IOException {
        int length = this.readUnsignedLeb128();
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StreamUtils.UTF_8);
    }

    public String readFixedString(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StreamUtils.UTF_8);
    }

    private void validateInt(int value, int minValue, int maxValue, String dataType) {
        if (value < minValue || value > maxValue) {
            throw new IllegalStateException("Not a " + dataType + " value: " + value);
        }
    }

    public boolean readBoolean() throws IOException {
        short value = this.readUInt8();
        this.validateInt(value, 0, 1, "boolean");
        return value != 0;
    }

    public short readUInt8() throws IOException {
        return (short)this.in.readUnsignedByte();
    }

    public byte readUInt8AsByte() throws IOException {
        return this.in.readByte();
    }

    public byte readInt8() throws IOException {
        return this.in.readByte();
    }

    public int readUInt16() throws IOException {
        return this.in.readUnsignedShort();
    }

    public short readUInt16AsShort() throws IOException {
        return this.in.readShort();
    }

    public short readInt16() throws IOException {
        return this.in.readShort();
    }

    public long readUInt32() throws IOException {
        return (long)this.in.readInt() & 0xFFFFFFFFL;
    }

    public int readUInt32AsInt() throws IOException {
        return this.in.readInt();
    }

    public int readInt32() throws IOException {
        return this.in.readInt();
    }

    public long readUInt64AsLong() throws IOException {
        return this.in.readLong();
    }

    public UnsignedLong readUInt64AsUnsignedLong() throws IOException {
        return UnsignedLong.fromLongBits((long)this.in.readLong());
    }

    public BigInteger readUInt64() throws IOException {
        byte[] bytes = new byte[8];
        this.readBytes(bytes);
        return new BigInteger(bytes);
    }

    public long readInt64() throws IOException {
        return this.in.readLong();
    }

    public Timestamp readDateTime() throws IOException {
        long value = this.readUInt32();
        return new Timestamp(TimeUnit.SECONDS.toMillis(value));
    }

    public Date readDate() throws IOException {
        int daysSinceEpoch = this.readUInt16();
        long utcMillis = (long)daysSinceEpoch * ClickHouseRowBinaryStream.MILLIS_IN_DAY;
        long localMillis = utcMillis - (long)this.timeZone.getOffset(utcMillis);
        return new Date(localMillis);
    }

    public float readFloat32() throws IOException {
        return this.in.readFloat();
    }

    public double readFloat64() throws IOException {
        return this.in.readDouble();
    }

    public Date[] readDateArray() throws IOException {
        int length = this.readUnsignedLeb128();
        Date[] dates = new Date[length];
        for (int i = 0; i < length; ++i) {
            dates[i] = this.readDate();
        }
        return dates;
    }

    public Timestamp[] readDateTimeArray() throws IOException {
        int length = this.readUnsignedLeb128();
        Timestamp[] dates = new Timestamp[length];
        for (int i = 0; i < length; ++i) {
            dates[i] = this.readDateTime();
        }
        return dates;
    }

    public String[] readStringArray() throws IOException {
        int length = this.readUnsignedLeb128();
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.readString();
        }
        return strings;
    }

    public byte[] readInt8Array() throws IOException {
        int length = this.readUnsignedLeb128();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readInt8();
        }
        return bytes;
    }

    public byte[] readUInt8ArrayAsByte() throws IOException {
        int length = this.readUnsignedLeb128();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readUInt8AsByte();
        }
        return bytes;
    }

    public short[] readUInt8Array() throws IOException {
        int length = this.readUnsignedLeb128();
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readUInt8();
        }
        return shorts;
    }

    public short[] readInt16Array() throws IOException {
        int length = this.readUnsignedLeb128();
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readInt16();
        }
        return shorts;
    }

    public short[] readUInt16ArrayAsShort() throws IOException {
        int length = this.readUnsignedLeb128();
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readUInt16AsShort();
        }
        return shorts;
    }

    public int[] readUInt16Array() throws IOException {
        int length = this.readUnsignedLeb128();
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readUInt16();
        }
        return ints;
    }

    public int[] readInt32Array() throws IOException {
        int length = this.readUnsignedLeb128();
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readInt32();
        }
        return ints;
    }

    public int[] readUInt32ArrayAsInt() throws IOException {
        int length = this.readUnsignedLeb128();
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readUInt32AsInt();
        }
        return ints;
    }

    public long[] readUInt32Array() throws IOException {
        int length = this.readUnsignedLeb128();
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readUInt32();
        }
        return longs;
    }

    public long[] readInt64Array() throws IOException {
        int length = this.readUnsignedLeb128();
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readInt64();
        }
        return longs;
    }

    public long[] readUInt64ArrayAsLong() throws IOException {
        int length = this.readUnsignedLeb128();
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readUInt64AsLong();
        }
        return longs;
    }

    public UnsignedLong[] readUInt64ArrayAsUnsignedLong() throws IOException {
        int length = this.readUnsignedLeb128();
        UnsignedLong[] longs = new UnsignedLong[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readUInt64AsUnsignedLong();
        }
        return longs;
    }

    public BigInteger[] readUInt64Array() throws IOException {
        int length = this.readUnsignedLeb128();
        BigInteger[] bigs = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            bigs[i] = this.readUInt64();
        }
        return bigs;
    }

    public float[] readFloat32Array() throws IOException {
        int length = this.readUnsignedLeb128();
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this.readFloat32();
        }
        return floats;
    }

    public double[] readFloat64Array() throws IOException {
        int length = this.readUnsignedLeb128();
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.readFloat64();
        }
        return doubles;
    }

    public UUID readUUID() throws IOException {
        byte[] array = new byte[16];
        this.readBytes(array);
        ByteBuffer bb = ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public BigDecimal readDecimal32(int scale) throws IOException {
        int i = this.in.readInt();
        BigDecimal ten = BigDecimal.valueOf(10L);
        BigDecimal s = ten.pow(scale);
        return new BigDecimal(i).divide(s);
    }

    public BigDecimal readDecimal64(int scale) throws IOException {
        long i = this.in.readLong();
        BigDecimal ten = BigDecimal.valueOf(10L);
        BigDecimal s = ten.pow(scale);
        return new BigDecimal(i).divide(s);
    }

    public BigDecimal readDecimal128(int scale) throws IOException {
        byte[] r = new byte[16];
        for (int i = 16; i > 0; --i) {
            r[i - 1] = this.in.readByte();
        }
        BigDecimal res = new BigDecimal(new BigInteger(r), scale);
        return res;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

