/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.exceptions;

import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.exceptions.JedisDataException;

public class JedisBroadcastException
extends JedisDataException {
    private static final String BROADCAST_ERROR_MESSAGE = "A failure occurred while broadcasting the command.";
    private final Map<HostAndPort, SingleReply> replies = new HashMap<HostAndPort, SingleReply>();

    public JedisBroadcastException() {
        super(BROADCAST_ERROR_MESSAGE);
    }

    public void addReply(HostAndPort node, Object reply) {
        this.replies.put(node, new SingleReply(reply));
    }

    public void addError(HostAndPort node, JedisDataException error) {
        this.replies.put(node, new SingleReply(error));
    }

    public static class SingleReply {
        private final Object reply;
        private final JedisDataException error;

        public SingleReply(Object reply) {
            this.reply = reply;
            this.error = null;
        }

        public SingleReply(JedisDataException error) {
            this.reply = null;
            this.error = error;
        }

        public Object getReply() {
            return this.reply;
        }

        public JedisDataException getError() {
            return this.error;
        }
    }
}

