/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.history;

import io.rong.RongCloud;
import io.rong.exception.ParamException;
import io.rong.models.response.HistoryMessageResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class History {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "message/history";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public History(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public HistoryMessageResult get(String date) throws Exception {
        if (date == null) {
            throw new ParamException("Paramer 'date' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&date=").append(URLEncoder.encode(date.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/history.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (HistoryMessageResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn)), HistoryMessageResult.class);
    }

    public ResponseResult remove(String date) throws Exception {
        if (date == null) {
            throw new ParamException("Paramer 'date' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&date=").append(URLEncoder.encode(date.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/history/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

