/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message._private;

import io.rong.RongCloud;
import io.rong.exception.ParamException;
import io.rong.models.CommonConstrants;
import io.rong.models.Result;
import io.rong.models.Templates;
import io.rong.models.message.PrivateMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.message.TemplateMessage;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class Private {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "message/_private";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Private(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult send(PrivateMessage message) throws Exception {
        String body;
        if (null == message) {
            throw new ParamException(CommonConstrants.RCLOUD_PARAM_NULL, PATH, "Paramer 'message' is required");
        }
        String errMsg = CommonUtil.checkFiled(message, PATH, "send");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderUserId().toString(), UTF8));
        for (int i = 0; i < message.getTargetId().length; ++i) {
            String child = message.getTargetId()[i];
            sb.append("&toUserId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent().toString(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData().toString(), UTF8));
        }
        if (message.getCount() != null) {
            sb.append("&count=").append(URLEncoder.encode(message.getCount().toString(), UTF8));
        }
        if (message.getVerifyBlacklist() != null) {
            sb.append("&verifyBlacklist=").append(URLEncoder.encode(message.getVerifyBlacklist().toString(), UTF8));
        }
        if (message.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(message.getIsPersisted().toString(), UTF8));
        }
        if (message.getIsCounted() != null) {
            sb.append("&isCounted=").append(URLEncoder.encode(message.getIsCounted().toString(), UTF8));
        }
        if (message.getIsIncludeSender() != null) {
            sb.append("&isIncludeSender=").append(URLEncoder.encode(message.getIsIncludeSender().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/private/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ResponseResult sendTemplate(TemplateMessage message) throws Exception {
        String errMsg = CommonUtil.checkFiled(message, PATH, "sendTemplate");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        Templates templateMessage = new Templates();
        ArrayList<String> toUserIds = new ArrayList<String>();
        ArrayList<Map<String, String>> values = new ArrayList<Map<String, String>>();
        ArrayList<String> push = new ArrayList<String>();
        for (Map.Entry<String, TemplateMessage.Data> vo : message.getContent().entrySet()) {
            toUserIds.add(vo.getKey());
            values.add(vo.getValue().getData());
            push.add(vo.getValue().getPush());
        }
        templateMessage.setFromUserId(message.getSenderId());
        templateMessage.setToUserId(toUserIds.toArray(new String[toUserIds.size()]));
        templateMessage.setObjectName(message.getObjectName());
        templateMessage.setContent(message.getTemplate().toString());
        templateMessage.setValues(values);
        templateMessage.setPushContent(push.toArray(new String[push.size()]));
        templateMessage.setPushData(message.getPushData());
        templateMessage.setVerifyBlacklist(message.getVerifyBlacklist());
        templateMessage.setContentAvailable(message.getContentAvailable());
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/private/publish_template.json", "application/json");
        HttpUtil.setBodyParameter(templateMessage.toString(), conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sendTemplate", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result recall(RecallMessage message) throws Exception {
        String errMsg = CommonUtil.checkFiled(message, PATH, "recall");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode("1", UTF8));
        sb.append("&fromUserId=").append(URLEncoder.encode(message.senderUserId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(message.targetId.toString(), UTF8));
        sb.append("&messageUID=").append(URLEncoder.encode(message.uId.toString(), UTF8));
        sb.append("&sentTime=").append(URLEncoder.encode(message.sentTime.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/recall.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "recall", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

