/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom.demotion;

import io.rong.RongCloud;
import io.rong.models.response.ChatroomDemotionMsgResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Demotion {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom/demotion";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Demotion(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult add(String[] objectName) throws Exception {
        String message = CommonUtil.checkParam("type", objectName, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectName.length; ++i) {
            String child = objectName[i];
            sb.append("&objectName=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/message/priority/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ResponseResult remove(String[] objectNames) throws Exception {
        String message = CommonUtil.checkParam("type", objectNames, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectNames.length; ++i) {
            String child = objectNames[i];
            sb.append("&objectName=").append(URLEncoder.encode(child, UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/message/priority/remove.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ChatroomDemotionMsgResult getList() throws Exception {
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/message/priority/query.json", "application/x-www-form-urlencoded");
        return (ChatroomDemotionMsgResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn)), ChatroomDemotionMsgResult.class);
    }
}

