/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Field;
import junitparams.internal.InvokeParameterisedMethod;
import junitparams.internal.TestMethod;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

public class ParameterisedTestMethodRunner {
    public final TestMethod method;
    private int count;

    public ParameterisedTestMethodRunner(TestMethod testMethod) {
        this.method = testMethod;
    }

    public int nextCount() {
        return this.count++;
    }

    public int count() {
        return this.count;
    }

    Object currentParamsFromAnnotation() {
        return this.method.parametersSets()[this.nextCount()];
    }

    void runTestMethod(Statement methodInvoker, RunNotifier notifier) {
        Description methodWithParams = this.findChildForParams(methodInvoker, this.method.describe());
        this.runMethodInvoker(notifier, methodInvoker, methodWithParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMethodInvoker(RunNotifier notifier, Statement methodInvoker, Description methodWithParams) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, methodWithParams);
        eachNotifier.fireTestStarted();
        try {
            methodInvoker.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private Description findChildForParams(Statement methodInvoker, Description methodDescription) {
        if (System.getProperty("JUnitParams.flat") != null) {
            return methodDescription;
        }
        InvokeParameterisedMethod parameterisedInvoker = this.findParameterisedMethodInvokerInChain(methodInvoker);
        for (Description child : methodDescription.getChildren()) {
            if (!parameterisedInvoker.matchesDescription(child)) continue;
            return child;
        }
        return null;
    }

    private InvokeParameterisedMethod findParameterisedMethodInvokerInChain(Statement methodInvoker) {
        while (methodInvoker != null && !(methodInvoker instanceof InvokeParameterisedMethod)) {
            methodInvoker = this.nextChainedInvoker(methodInvoker);
        }
        if (methodInvoker == null) {
            throw new RuntimeException("Cannot find invoker for the parameterised method. Using wrong JUnit version?");
        }
        return (InvokeParameterisedMethod)methodInvoker;
    }

    private Statement nextChainedInvoker(Statement methodInvoker) {
        Field[] declaredFields;
        for (Field field : declaredFields = methodInvoker.getClass().getDeclaredFields()) {
            Statement statement = this.statementOrNull(methodInvoker, field);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    private Statement statementOrNull(Statement methodInvoker, Field field) {
        if (Statement.class.isAssignableFrom(field.getType())) {
            return this.getOriginalStatement(methodInvoker, field);
        }
        return null;
    }

    private Statement getOriginalStatement(Statement methodInvoker, Field field) {
        field.setAccessible(true);
        try {
            return (Statement)field.get(methodInvoker);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

