/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.zalando.tracer.Generator;
import org.zalando.tracer.StackedTraceListener;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.TraceListeners;
import org.zalando.tracer.Tracer;

final class StackedTracer
implements Tracer {
    private final Map<String, ThreadLocal<Deque<String>>> traces;
    private final Map<String, Generator> generators;
    private final TraceListener listeners;
    private final TraceListener stackedListeners;

    StackedTracer(Map<String, Generator> generators, Collection<TraceListener> listeners) {
        this.traces = generators.keySet().stream().collect(Collectors.toMap(Function.identity(), name -> ThreadLocal.withInitial(ArrayDeque::new)));
        this.generators = generators;
        Map<Boolean, List<TraceListener>> partitions = listeners.stream().collect(Collectors.partitioningBy(StackedTraceListener.class::isInstance));
        this.listeners = TraceListeners.compound((Collection<TraceListener>)partitions.get(Boolean.FALSE));
        this.stackedListeners = TraceListeners.compound((Collection<TraceListener>)partitions.get(Boolean.TRUE));
    }

    @Override
    public void start(Function<String, String> provider) {
        this.traces.forEach((? super K name, ? super V state) -> {
            Deque queue = (Deque)state.get();
            String previous = (String)queue.peekLast();
            String current = this.generate(provider, (String)name);
            queue.add(current);
            this.runIf(this.listeners::onStop, (String)name, previous);
            this.runIf(this.listeners::onStart, (String)name, current);
            this.runIf(this.stackedListeners::onStart, (String)name, current);
        });
    }

    @Override
    public boolean isActive() {
        return this.traces.values().stream().map(ThreadLocal::get).anyMatch(queue -> !queue.isEmpty());
    }

    private String generate(Function<String, String> provider, String name) {
        return Optional.ofNullable(provider.apply(name)).orElseGet(() -> this.generators.get(name).generate());
    }

    @Override
    public Trace get(final String name) {
        final ThreadLocal<Deque<String>> state = this.getAndCheckState(name);
        return new Trace(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return StackedTracer.this.getAndCheckValue(name, state);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.traces.forEach((? super K name, ? super V state) -> consumer.accept((String)name, this.getAndCheckValue((String)name, (ThreadLocal<Deque<String>>)state)));
    }

    @Override
    public void stop() {
        this.traces.forEach((? super K name, ? super V state) -> {
            Deque queue = (Deque)state.get();
            String previous = this.checkValue((String)name, (String)queue.pollLast());
            String current = (String)queue.peekLast();
            this.runIf(this.listeners::onStop, (String)name, previous);
            this.runIf(this.stackedListeners::onStop, (String)name, previous);
            this.runIf(this.listeners::onStart, (String)name, current);
        });
    }

    private void runIf(BiConsumer<String, String> action, String name, @Nullable String current) {
        if (current != null) {
            action.accept(name, current);
        }
    }

    private ThreadLocal<Deque<String>> getAndCheckState(String name) {
        ThreadLocal<Deque<String>> state = this.traces.get(name);
        if (state == null) {
            throw new IllegalArgumentException("No such trace: " + name);
        }
        return state;
    }

    private String getAndCheckValue(String name, ThreadLocal<Deque<String>> state) {
        String value = state.get().peekLast();
        return this.checkValue(name, value);
    }

    private String checkValue(String name, @Nullable String value) {
        if (value == null) {
            throw new IllegalStateException(name + " has not been started");
        }
        return value;
    }
}

