/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.util.Arrays;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.apiguardian.api.API;
import org.zalando.tracer.Generator;

@API(status=API.Status.STABLE)
public final class PhraseGenerator
implements Generator {
    private static final String[] QUALIFIERS = new String[]{"admiring", "adoring", "agitated", "amazing", "angry", "awesome", "backstabbing", "berserk", "big", "boring", "clever", "cocky", "compassionate", "condescending", "cranky", "desperate", "determined", "distracted", "dreamy", "drunk", "ecstatic", "elated", "elegant", "evil", "fervent", "focused", "furious", "gigantic", "gloomy", "goofy", "grave", "happy", "high", "hopeful", "hungry", "infallible", "jolly", "jovial", "kickass", "lonely", "loving", "mad", "modest", "naughty", "nauseous", "nostalgic", "peaceful", "pedantic", "pensive", "prickly", "reverent", "romantic", "sad", "serene", "sharp", "sick", "silly", "sleepy", "small", "stoic", "stupefied", "suspicious", "tender", "thirsty", "tiny", "trusting", "zen"};
    private static final String[] NAMES = new String[]{"albattani", "allen", "almeida", "agnesi", "archimedes", "ardinghelli", "aryabhata", "austin", "babbage", "banach", "bardeen", "bartik", "bassi", "bell", "bhabha", "bhaskara", "blackwell", "bohr", "booth", "borg", "bose", "boyd", "brahmagupta", "brattain", "brown", "carson", "chandrasekhar", "shannon", "colden", "cori", "cray", "curran", "curie", "darwin", "davinci", "dijkstra", "dubinsky", "easley", "einstein", "elion", "engelbart", "euclid", "euler", "fermat", "fermi", "feynman", "franklin", "galileo", "gates", "goldberg", "goldstine", "goldwasser", "golick", "goodall", "hamilton", "hawking", "heisenberg", "heyrovsky", "hodgkin", "hoover", "hopper", "hugle", "hypatia", "jang", "jennings", "jepsen", "joliot", "jones", "kalam", "kare", "keller", "khorana", "kilby", "kirch", "knuth", "kowalevski", "lalande", "lamarr", "lamport", "leakey", "leavitt", "lichterman", "liskov", "lovelace", "lumiere", "mahavira", "mayer", "mccarthy", "mcclintock", "mclean", "mcnulty", "meitner", "meninsky", "mestorf", "minsky", "mirzakhani", "morse", "murdock", "newton", "nobel", "noether", "northcutt", "noyce", "panini", "pare", "pasteur", "payne", "perlman", "pike", "poincare", "poitras", "ptolemy", "raman", "ramanujan", "ride", "montalcini", "ritchie", "roentgen", "rosalind", "saha", "sammet", "shaw", "shirley", "shockley", "sinoussi", "snyder", "spence", "stallman", "stonebraker", "swanson", "swartz", "swirles", "tesla", "thompson", "torvalds", "turing", "varahamihira", "visvesvaraya", "volhard", "wescoff", "williams", "wilson", "wing", "wozniak", "wright", "yalow", "yonath"};
    private static final String[] VERBS = new String[]{"asks", "pays", "sees", "waits", "calls", "feeds", "helps", "knows", "likes", "meets", "saves", "tells"};
    private final IntUnaryOperator random = bound -> ThreadLocalRandom.current().nextInt(bound);

    @Override
    public String generate() {
        return this.generate(this.random);
    }

    String generate(IntUnaryOperator random) {
        String phrase = this.phrase(random);
        if (phrase.contains("boring_wozniak")) {
            return this.generate(random);
        }
        return phrase;
    }

    private String phrase(IntUnaryOperator random) {
        return this.qualifiedName(random) + "_" + this.verb(random) + "_" + this.qualifiedName(random);
    }

    private String qualifiedName(IntUnaryOperator random) {
        return this.qualifier(random) + "_" + this.name(random);
    }

    private String qualifier(IntUnaryOperator random) {
        return this.of(QUALIFIERS, random);
    }

    private String name(IntUnaryOperator random) {
        return this.of(NAMES, random);
    }

    private String verb(IntUnaryOperator random) {
        return this.of(VERBS, random);
    }

    private String of(String[] options, IntUnaryOperator random) {
        return options[random.applyAsInt(options.length)];
    }

    long maxCombinations() {
        return QUALIFIERS.length * NAMES.length * VERBS.length * QUALIFIERS.length * NAMES.length;
    }

    int minLength() {
        return PhraseGenerator.min(QUALIFIERS) * 2 + PhraseGenerator.min(NAMES) * 2 + PhraseGenerator.min(VERBS) + 4;
    }

    int maxLength() {
        return PhraseGenerator.max(QUALIFIERS) * 2 + PhraseGenerator.max(NAMES) * 2 + PhraseGenerator.max(VERBS) + 4;
    }

    private static int min(String[] array) {
        return PhraseGenerator.length(array, IntStream::min);
    }

    private static int max(String[] array) {
        return PhraseGenerator.length(array, IntStream::max);
    }

    private static int length(String[] array, Function<IntStream, OptionalInt> f) {
        return f.apply(Arrays.stream(array).mapToInt(String::length)).orElse(0);
    }
}

