/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.xolstice.maven.plugin.protobuf.AbstractProtocMojo;

public abstract class AbstractProtocTestCompileMojo
extends AbstractProtocMojo {
    @Parameter(required=true, defaultValue="${basedir}/src/test/proto")
    private File protoTestSourceRoot;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-test-resources/protobuf/descriptor-sets")
    private File descriptorSetOutputDirectory;
    @Parameter(required=false, defaultValue="test")
    protected String descriptorSetClassifier;

    @Override
    protected void doAttachProtoSources() {
        this.projectHelper.addTestResource(this.project, this.getProtoSourceRoot().getAbsolutePath(), (List)ImmutableList.copyOf(this.getIncludes()), (List)ImmutableList.copyOf(this.getExcludes()));
    }

    @Override
    protected void doAttachGeneratedFiles() {
        File outputDirectory = this.getOutputDirectory();
        this.project.addTestCompileSourceRoot(outputDirectory.getAbsolutePath());
        if (this.writeDescriptorSet) {
            File descriptorSetFile = new File(this.getDescriptorSetOutputDirectory(), this.descriptorSetFileName);
            this.projectHelper.attachArtifact(this.project, "test-protobin", this.descriptorSetClassifier, descriptorSetFile);
        }
        this.buildContext.refresh(outputDirectory);
    }

    @Override
    protected List<Artifact> getDependencyArtifacts() {
        return this.project.getTestArtifacts();
    }

    @Override
    protected File getDescriptorSetOutputDirectory() {
        return this.descriptorSetOutputDirectory;
    }

    @Override
    protected File getProtoSourceRoot() {
        return this.protoTestSourceRoot;
    }
}

