/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractNodeTester
implements NodeTester {
    @Override
    public void testNode(Node aNode, NodeTest forTest) throws NodeTestException {
        switch (aNode.getNodeType()) {
            case 2: {
                this.testAttribute((Attr)aNode);
                break;
            }
            case 4: {
                this.testCDATASection((CDATASection)aNode);
                break;
            }
            case 8: {
                this.testComment((Comment)aNode);
                break;
            }
            case 10: {
                this.testDocumentType((DocumentType)aNode);
                break;
            }
            case 1: {
                this.testElement((Element)aNode);
                break;
            }
            case 6: {
                this.testEntity((Entity)aNode);
                break;
            }
            case 5: {
                this.testEntityReference((EntityReference)aNode);
                break;
            }
            case 12: {
                this.testNotation((Notation)aNode);
                break;
            }
            case 7: {
                this.testProcessingInstruction((ProcessingInstruction)aNode);
                break;
            }
            case 3: {
                this.testText((Text)aNode);
                break;
            }
            default: {
                throw new NodeTestException("No delegate method for Node type", aNode);
            }
        }
    }

    public void testAttribute(Attr attribute) throws NodeTestException {
        this.unhandled(attribute);
    }

    public void testCDATASection(CDATASection cdata) throws NodeTestException {
        this.unhandled(cdata);
    }

    public void testComment(Comment comment) throws NodeTestException {
        this.unhandled(comment);
    }

    public void testDocumentType(DocumentType doctype) throws NodeTestException {
        this.unhandled(doctype);
    }

    public void testElement(Element element) throws NodeTestException {
        this.unhandled(element);
    }

    public void testEntity(Entity entity) throws NodeTestException {
        this.unhandled(entity);
    }

    public void testEntityReference(EntityReference reference) throws NodeTestException {
        this.unhandled(reference);
    }

    public void testNotation(Notation notation) throws NodeTestException {
        this.unhandled(notation);
    }

    public void testProcessingInstruction(ProcessingInstruction instr) throws NodeTestException {
        this.unhandled(instr);
    }

    public void testText(Text text) throws NodeTestException {
        this.unhandled(text);
    }

    private void unhandled(Node aNode) throws NodeTestException {
        throw new NodeTestException("Test fails by default in AbstractNodeTester" + aNode, aNode);
    }

    @Override
    public void noMoreNodes(NodeTest forTest) throws NodeTestException {
    }
}

