/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.verapdf.model.tools.xmp.validators.ArrayTypeValidator;
import org.verapdf.model.tools.xmp.validators.DateTypeValidator;
import org.verapdf.model.tools.xmp.validators.LangAltValidator;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.tools.xmp.validators.StructuredTypeValidator;
import org.verapdf.model.tools.xmp.validators.StructuredTypeWithRestrictedFieldsValidator;
import org.verapdf.model.tools.xmp.validators.TypeValidator;
import org.verapdf.model.tools.xmp.validators.URITypeValidator;
import org.verapdf.model.tools.xmp.validators.URLTypeValidator;
import org.verapdf.model.tools.xmp.validators.XPathTypeValidator;

public class ValidatorsContainer {
    private Map<String, TypeValidator> validators;
    private Map<String, ArrayTypeValidator> arrayValidators;

    ValidatorsContainer() {
        this.arrayValidators = new HashMap<String, ArrayTypeValidator>();
        for (ArrayTypeValidator.ArrayTypeEnum arrayTypeEnum : ArrayTypeValidator.ArrayTypeEnum.values()) {
            this.arrayValidators.put(arrayTypeEnum.getType(), ArrayTypeValidator.fromValues(arrayTypeEnum, this));
        }
        this.validators = new HashMap<String, TypeValidator>();
        this.validators.put("date", new DateTypeValidator());
        this.validators.put("lang alt", new LangAltValidator());
        this.validators.put("uri", new URITypeValidator());
        this.validators.put("url", new URLTypeValidator());
        this.validators.put("xpath", new XPathTypeValidator());
        for (Enum enum_ : SimpleTypeValidator.SimpleTypeEnum.values()) {
            this.validators.put(((SimpleTypeValidator.SimpleTypeEnum)enum_).getType(), SimpleTypeValidator.fromValue((SimpleTypeValidator.SimpleTypeEnum)enum_));
        }
    }

    ValidatorsContainer(ValidatorsContainer validatorsContainer) {
        this.validators = new HashMap<String, TypeValidator>(validatorsContainer.validators);
        this.arrayValidators = new HashMap<String, ArrayTypeValidator>(validatorsContainer.arrayValidators);
    }

    boolean registerSimpleValidator(String typeName, Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument pattern can not be null");
        }
        return this.registerSimpleValidator(typeName, SimpleTypeValidator.fromValue(pattern));
    }

    boolean registerSimpleValidator(String typeName, SimpleTypeValidator simpleTypeValidator) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument typeName can not be null");
        }
        if (simpleTypeValidator == null) {
            throw new IllegalArgumentException("Argument pattern can not be null");
        }
        String type = ValidatorsContainer.getSimplifiedType(typeName);
        if (this.validators.containsKey(type)) {
            return false;
        }
        this.validators.put(type, simpleTypeValidator);
        return true;
    }

    boolean registerStructuredValidator(String typeName, String typeNamespaceURI, Map<String, String> childrenTypes) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument typeName can not be null");
        }
        if (typeNamespaceURI == null) {
            throw new IllegalArgumentException("Argument typeNamespaceURI can not be null");
        }
        if (childrenTypes == null || childrenTypes.isEmpty()) {
            throw new IllegalArgumentException("Argument childrenTypes can not be null or empty");
        }
        String type = ValidatorsContainer.getSimplifiedType(typeName);
        if (this.validators.containsKey(type)) {
            return false;
        }
        this.validators.put(type, StructuredTypeValidator.fromValues(typeNamespaceURI, childrenTypes, this));
        return true;
    }

    boolean registerStructuredWithRestrictedFieldsValidator(String typeName, String typeNamespaceURI, Map<String, String> childrenTypes, Map<String, Pattern> childrenRestrictedTypes) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument typeName can not be null");
        }
        if (typeNamespaceURI == null) {
            throw new IllegalArgumentException("Argument typeNamespaceURI can not be null");
        }
        if (childrenTypes == null) {
            throw new IllegalArgumentException("Argument childrenTypes can not be null or empty");
        }
        if (childrenRestrictedTypes == null) {
            throw new IllegalArgumentException("Argument childrenClosedTypes can not be null or empty");
        }
        String type = ValidatorsContainer.getSimplifiedType(typeName);
        if (this.validators.containsKey(type)) {
            return false;
        }
        this.validators.put(type, StructuredTypeWithRestrictedFieldsValidator.fromValues(typeNamespaceURI, childrenTypes, childrenRestrictedTypes, this));
        return true;
    }

    public boolean validate(VeraPDFXMPNode node, String typeName) {
        String type = ValidatorsContainer.getSimplifiedType(typeName);
        for (ArrayTypeValidator.ArrayTypeEnum entr : ArrayTypeValidator.ArrayTypeEnum.values()) {
            String prefix = entr.getType() + " ";
            if (!type.startsWith(prefix)) continue;
            return this.arrayValidators.get(entr.getType()).isCorresponding(node, type.substring(prefix.length()));
        }
        return this.validators.containsKey(type) && this.validators.get(type).isCorresponding(node);
    }

    public boolean isKnownType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument typeName can not be null");
        }
        boolean needCheck = true;
        String type = ValidatorsContainer.getSimplifiedType(typeName);
        block0: while (needCheck) {
            needCheck = false;
            for (ArrayTypeValidator.ArrayTypeEnum entr : ArrayTypeValidator.ArrayTypeEnum.values()) {
                String prefix = entr.getType() + " ";
                if (!type.startsWith(prefix)) continue;
                type = type.substring(prefix.length());
                needCheck = true;
                continue block0;
            }
        }
        return this.validators.containsKey(type);
    }

    private static String getSimplifiedType(String type) {
        String res = type.toLowerCase().replaceAll("(open |closed )?(choice |choice$)(of )?", "").trim();
        if (res.isEmpty()) {
            res = "text";
        } else {
            if (res.endsWith("lang alt")) {
                return res;
            }
            for (ArrayTypeValidator.ArrayTypeEnum entr : ArrayTypeValidator.ArrayTypeEnum.values()) {
                String prefix = entr.getType();
                if (!res.endsWith(prefix)) continue;
                res = res + " text";
                break;
            }
        }
        return res;
    }
}

