/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ujmp.core.util.io.BufferedRandomAccessFile;

public class SeekableLineInputStream
extends InputStream {
    private static final long MAXLINECOUNT = 1000L;
    private final long[] countsTotal = new long[256];
    private final long[] diffSum = new long[256];
    private int bufferSize = 65536;
    private BufferedRandomAccessFile in;
    private final List<Long> lineEnds = new ArrayList<Long>();
    private long maxLineLength = 0L;

    public SeekableLineInputStream(String file) throws IOException {
        this(new File(file));
    }

    public SeekableLineInputStream(File file) throws IOException {
        this.in = new BufferedRandomAccessFile(file, "r", this.bufferSize);
        long totalLength = this.in.length();
        long last = -1L;
        long lineCount = 0L;
        long[][] countsPerLine = new long[2][256];
        long[] c = countsPerLine[0];
        long[] c0 = countsPerLine[0];
        long[] c1 = countsPerLine[1];
        byte[] bytes = new byte[this.bufferSize];
        for (long pos = 0L; pos < totalLength; pos += (long)this.bufferSize) {
            Arrays.fill(bytes, (byte)0);
            this.in.read(pos, bytes);
            for (int i = 0; i < this.bufferSize; ++i) {
                long length;
                byte b = bytes[i];
                if (lineCount < 1000L) {
                    int n = b + 128;
                    c[n] = c[n] + 1L;
                }
                if (b != 10) continue;
                if (lineCount < 1000L) {
                    int j = 256;
                    while (--j != -1) {
                        int n = j;
                        this.countsTotal[n] = this.countsTotal[n] + c[j];
                    }
                    j = 256;
                    while (--j != -1) {
                        int n = j;
                        this.diffSum[n] = this.diffSum[n] + Math.abs(c0[j] - c1[j]);
                    }
                    if (lineCount == 0L) {
                        Arrays.fill(this.diffSum, 0L);
                    }
                    c = countsPerLine[(int)(++lineCount % 2L)];
                    Arrays.fill(c, 0L);
                }
                if ((length = pos + (long)i - last) > this.maxLineLength) {
                    this.maxLineLength = length;
                }
                this.lineEnds.add(pos + (long)i);
                last = pos + (long)i;
            }
        }
        this.lineEnds.remove(totalLength - 1L);
        for (int i = 0; i < 256; ++i) {
            if (this.countsTotal[i] <= 0L) continue;
            System.out.println(i - 128 + " " + this.countsTotal[i] + " " + this.diffSum[i]);
        }
        System.out.println("This file has " + this.getLineCount() + " lines");
        if (this.maxLineLength + 1L > (long)this.bufferSize) {
            this.bufferSize = (int)this.maxLineLength + 1;
            this.in.close();
            this.in = new BufferedRandomAccessFile(file, "r", this.bufferSize);
        }
    }

    public long getMaxLineLength() {
        return this.maxLineLength;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getLineCount() {
        return this.lineEnds.size() + 1;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public String getMostProbableDelimiter() {
        long lines = Math.min(1000L, (long)this.lineEnds.size());
        return null;
    }

    public String readLine(int lineNumber) throws IOException {
        long start = 0L;
        if (lineNumber > 0) {
            start = this.lineEnds.get(lineNumber - 1) + 1L;
        }
        long end = 0L;
        end = lineNumber < this.getLineCount() - 1 ? this.lineEnds.get(lineNumber).longValue() : this.in.length();
        int length = (int)(end - start);
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        this.in.read(start, bytes);
        String line = bytes[bytes.length - 1] == 13 ? new String(bytes, 0, bytes.length - 1) : new String(bytes);
        return line;
    }
}

