/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.HasObjectArray;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class DefaultDenseObjectMatrix2D
extends AbstractDenseObjectMatrix2D
implements HasObjectArray {
    private static final long serialVersionUID = 8929799323811301397L;
    private final Object[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseObjectMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        if (m instanceof DefaultDenseObjectMatrix2D) {
            Object[] v = ((DefaultDenseObjectMatrix2D)m).values;
            this.values = new Object[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new Object[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setObject(m.getAsObject(c), c);
            }
        }
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    public DefaultDenseObjectMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new Object[rows * columns];
    }

    public DefaultDenseObjectMatrix2D(Object[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    public Object getObject(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setObject(Object value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public Object getObject(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setObject(Object value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix copy() {
        Object[] result = new Object[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseObjectMatrix2D m = new DefaultDenseObjectMatrix2D(result, this.rows, this.cols);
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        Object[] result = new Object[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseObjectMatrix2D(result, this.cols, this.rows);
    }

    public Object[] getObjectArray() {
        return this.values;
    }
}

