/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.view.reactive;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.view.AbstractView;
import org.springframework.web.reactive.result.view.RequestContext;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring5.ISpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.context.webflux.IReactiveDataDriverContextVariable;
import org.thymeleaf.spring5.context.webflux.SpringWebFluxExpressionContext;
import org.thymeleaf.spring5.context.webflux.SpringWebFluxThymeleafRequestContext;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContext;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ThymeleafReactiveView
extends AbstractView
implements BeanNameAware {
    protected static final Logger logger = LoggerFactory.getLogger(ThymeleafReactiveView.class);
    public static final int DEFAULT_RESPONSE_CHUNK_SIZE_BYTES = Integer.MAX_VALUE;
    private static final String WEBFLUX_CONVERSION_SERVICE_NAME = "webFluxConversionService";
    private String beanName = null;
    private ISpringWebFluxTemplateEngine templateEngine = null;
    private String templateName = null;
    private Locale locale = null;
    private Map<String, Object> staticVariables = null;
    private boolean defaultCharsetSet = false;
    private boolean supportedMediaTypesSet = false;
    private Set<String> markupSelectors = null;
    private Integer responseMaxChunkSizeBytes = null;

    public String getMarkupSelector() {
        return this.markupSelectors == null || this.markupSelectors.size() == 0 ? null : this.markupSelectors.iterator().next();
    }

    public void setMarkupSelector(String markupSelector) {
        this.markupSelectors = markupSelector == null || markupSelector.trim().length() == 0 ? null : Collections.singleton(markupSelector.trim());
    }

    boolean isDefaultCharsetSet() {
        return this.defaultCharsetSet;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        super.setDefaultCharset(defaultCharset);
        this.defaultCharsetSet = true;
    }

    boolean isSupportedMediaTypesSet() {
        return this.supportedMediaTypesSet;
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        super.setSupportedMediaTypes(supportedMediaTypes);
        this.supportedMediaTypesSet = true;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getResponseMaxChunkSizeBytes() {
        return this.responseMaxChunkSizeBytes == null ? Integer.MAX_VALUE : this.responseMaxChunkSizeBytes;
    }

    Integer getNullableResponseMaxChunkSize() {
        return this.responseMaxChunkSizeBytes;
    }

    public void setResponseMaxChunkSizeBytes(int responseMaxBufferSizeBytes) {
        this.responseMaxChunkSizeBytes = responseMaxBufferSizeBytes;
    }

    protected ISpringWebFluxTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    protected void setTemplateEngine(ISpringWebFluxTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Map<String, Object> getStaticVariables() {
        if (this.staticVariables == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.staticVariables);
    }

    public void addStaticVariable(String name, Object value) {
        if (this.staticVariables == null) {
            this.staticVariables = new HashMap<String, Object>(3, 1.0f);
        }
        this.staticVariables.put(name, value);
    }

    public void setStaticVariables(Map<String, ?> variables) {
        if (variables != null) {
            if (this.staticVariables == null) {
                this.staticVariables = new HashMap<String, Object>(3, 1.0f);
            }
            this.staticVariables.putAll(variables);
        }
    }

    protected Mono<Void> renderInternal(Map<String, Object> renderAttributes, MediaType contentType, ServerWebExchange exchange) {
        return this.renderFragmentInternal(this.markupSelectors, renderAttributes, contentType, exchange);
    }

    protected Mono<Void> renderFragmentInternal(Set<String> markupSelectorsToRender, Map<String, Object> renderAttributes, MediaType contentType, ServerWebExchange exchange) {
        Set processMarkupSelectors;
        Set markupSelectors;
        String templateName;
        Map pathVars;
        String viewTemplateName = this.getTemplateName();
        ISpringWebFluxTemplateEngine viewTemplateEngine = this.getTemplateEngine();
        if (viewTemplateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Property 'templateName' is required"));
        }
        if (this.getLocale() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Property 'locale' is required"));
        }
        if (viewTemplateEngine == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Property 'thymeleafTemplateEngine' is required"));
        }
        ServerHttpResponse response = exchange.getResponse();
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map<String, Object> templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if ((pathVars = (Map)exchange.getAttributes().get(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (renderAttributes != null) {
            mergedModel.putAll(renderAttributes);
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        RequestContext requestContext = new RequestContext(exchange, mergedModel, (MessageSource)applicationContext);
        SpringWebFluxThymeleafRequestContext thymeleafRequestContext = new SpringWebFluxThymeleafRequestContext(requestContext, exchange);
        mergedModel.put("springRequestContext", requestContext);
        mergedModel.put("thymeleafRequestContext", thymeleafRequestContext);
        ConversionService conversionService = applicationContext.containsBean(WEBFLUX_CONVERSION_SERVICE_NAME) ? (ConversionService)applicationContext.getBean(WEBFLUX_CONVERSION_SERVICE_NAME) : null;
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext(applicationContext, conversionService);
        mergedModel.put("thymeleaf::EvaluationContext", evaluationContext);
        boolean dataDriven = ThymeleafReactiveView.isDataDriven(mergedModel);
        IEngineConfiguration configuration = viewTemplateEngine.getConfiguration();
        SpringWebFluxExpressionContext context = new SpringWebFluxExpressionContext(configuration, exchange, this.getReactiveAdapterRegistry(), this.getLocale(), mergedModel);
        if (!viewTemplateName.contains("::")) {
            templateName = viewTemplateName;
            markupSelectors = null;
        } else {
            FragmentExpression fragmentExpression;
            IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            try {
                fragmentExpression = (FragmentExpression)parser.parseExpression((IExpressionContext)context, "~{" + viewTemplateName + "}");
            }
            catch (TemplateProcessingException e) {
                return Mono.error((Throwable)new IllegalArgumentException("Invalid template name specification: '" + viewTemplateName + "'"));
            }
            FragmentExpression.ExecutedFragmentExpression fragment = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)fragmentExpression, (StandardExpressionExecutionContext)StandardExpressionExecutionContext.NORMAL);
            templateName = FragmentExpression.resolveTemplateName((FragmentExpression.ExecutedFragmentExpression)fragment);
            markupSelectors = FragmentExpression.resolveFragments((FragmentExpression.ExecutedFragmentExpression)fragment);
            Map nameFragmentParameters = fragment.getFragmentParameters();
            if (nameFragmentParameters != null) {
                if (fragment.hasSyntheticParameters()) {
                    return Mono.error((Throwable)new IllegalArgumentException("Parameters in a view specification must be named (non-synthetic): '" + viewTemplateName + "'"));
                }
                context.setVariables(nameFragmentParameters);
            }
        }
        if (markupSelectors != null && markupSelectors.size() > 0) {
            if (markupSelectorsToRender != null && markupSelectorsToRender.size() > 0) {
                return Mono.error((Throwable)new IllegalArgumentException("A markup selector has been specified (" + Arrays.asList(markupSelectors) + ") for a view that was already being executed as a fragment (" + Arrays.asList(markupSelectorsToRender) + "). Only one fragment selection is allowed."));
            }
            processMarkupSelectors = markupSelectors;
        } else {
            processMarkupSelectors = markupSelectorsToRender != null && markupSelectorsToRender.size() > 0 ? markupSelectorsToRender : null;
        }
        int templateResponseMaxChunkSizeBytes = this.getResponseMaxChunkSizeBytes();
        HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
        Locale templateLocale = this.getLocale();
        if (templateLocale != null) {
            responseHeaders.setContentLanguage(templateLocale);
        }
        Charset charset = ThymeleafReactiveView.getCharset(contentType).orElse(this.getDefaultCharset());
        Publisher<DataBuffer> stream = viewTemplateEngine.processStream(templateName, processMarkupSelectors, context, response.bufferFactory(), contentType, charset, templateResponseMaxChunkSizeBytes);
        if (templateResponseMaxChunkSizeBytes == Integer.MAX_VALUE && !dataDriven) {
            return response.writeWith(stream);
        }
        return response.writeAndFlushWith((Publisher)Flux.from(stream).window(1));
    }

    private static Optional<Charset> getCharset(MediaType mediaType) {
        return mediaType != null ? Optional.ofNullable(mediaType.getCharset()) : Optional.empty();
    }

    private static boolean isDataDriven(Map<String, Object> mergedModel) {
        if (mergedModel == null || mergedModel.size() == 0) {
            return false;
        }
        for (Object value : mergedModel.values()) {
            if (!(value instanceof IReactiveDataDriverContextVariable)) continue;
            return true;
        }
        return false;
    }

    private ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext == null) {
            return null;
        }
        if (applicationContext != null) {
            try {
                return (ReactiveAdapterRegistry)applicationContext.getBean(ReactiveAdapterRegistry.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return null;
    }
}

