/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.tiles.Attribute;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.impl.InvalidTemplateException;
import org.apache.tiles.jsp.context.JspTilesRequestContext;
import org.apache.tiles.renderer.impl.AbstractTypeDetectingAttributeRenderer;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.tiles2.dialect.TilesDialect;
import org.thymeleaf.extras.tiles2.renderer.FragmentMetadata;
import org.thymeleaf.extras.tiles2.renderer.FragmentSpecRootRemovingWrapper;
import org.thymeleaf.extras.tiles2.renderer.TilesFragment;
import org.thymeleaf.fragment.DOMSelectorFragmentSpec;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.fragment.WholeFragmentSpec;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.standard.fragment.StandardFragmentProcessor;
import org.thymeleaf.standard.fragment.StandardFragmentSignatureNodeReferenceChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafAttributeRenderer
extends AbstractTypeDetectingAttributeRenderer {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafAttributeRenderer.class);
    private static final String SPRING3_STANDARD_DIALECT_CLASS_NAME = "org.thymeleaf.spring3.dialect.SpringStandardDialect";
    private static final String SPRING4_STANDARD_DIALECT_CLASS_NAME = "org.thymeleaf.spring4.dialect.SpringStandardDialect";

    public void write(Object value, Attribute attribute, TilesRequestContext tilesRequestContext) throws IOException {
        if (value == null) {
            throw new InvalidTemplateException("Cannot render a null template");
        }
        if (!(value instanceof String)) {
            throw new InvalidTemplateException("Cannot render a template that is not a String ('" + value.getClass().getName() + "')");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[THYMELEAF][TILES] Rendering Thymeleaf Tiles attribute with value \"{}\"", new Object[]{value});
        }
        ServletTilesRequestContext requestContext = ServletUtil.getServletRequest((TilesRequestContext)tilesRequestContext);
        String templateSelector = ((String)value).trim();
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = requestContext.getResponse();
        TemplateEngine templateEngine = (TemplateEngine)request.getAttribute("%%THYMELEAF_TEMPLATE_ENGINE%%");
        IProcessingContext processingContext = (IProcessingContext)request.getAttribute("%%THYMELEAF_PROCESSING_CONTEXT%%");
        FragmentMetadata fragmentBehaviour = (FragmentMetadata)request.getAttribute("%%THYMELEAF_FRAGMENT_METADATA%%");
        request.removeAttribute("%%THYMELEAF_FRAGMENT_METADATA%%");
        if (tilesRequestContext instanceof JspTilesRequestContext) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][TILES] Current Tiles Request Context is a JSPcontext. Flushing JspWriter to avoid fragment writing order problems.");
            }
            JspTilesRequestContext jspTilesRequestContext = (JspTilesRequestContext)tilesRequestContext;
            PageContext pageContext = jspTilesRequestContext.getPageContext();
            pageContext.getOut().flush();
        }
        boolean displayOnlySelectionChildren = fragmentBehaviour != null ? fragmentBehaviour.isDisplayOnlyChildren() : false;
        TilesFragment fragment = ThymeleafAttributeRenderer.computeTemplateSelector(templateEngine, processingContext, templateSelector);
        String templateName = fragment.getTemplateName();
        IFragmentSpec fragmentSpec = fragment.getFragmentSpec();
        if (displayOnlySelectionChildren) {
            fragmentSpec = new FragmentSpecRootRemovingWrapper(fragmentSpec);
        }
        templateEngine.process(templateName, processingContext, fragmentSpec, (Writer)response.getWriter());
        if (logger.isDebugEnabled()) {
            logger.debug("[THYMELEAF][TILES] Rendered Thymeleaf Tiles attribute with value \"{}\"", new Object[]{value});
        }
    }

    private static TilesFragment computeTemplateSelector(TemplateEngine templateEngine, IProcessingContext processingContext, String templateSelector) {
        if (!templateEngine.isInitialized()) {
            templateEngine.initialize();
        }
        if (!ThymeleafAttributeRenderer.isStandardDialectPresent(templateEngine)) {
            return ThymeleafAttributeRenderer.computeNonStandardFragment(templateEngine, templateSelector);
        }
        Configuration configuration = templateEngine.getConfiguration();
        String tilesDialectPrefix = ThymeleafAttributeRenderer.getTilesDialectPrefix(templateEngine);
        StandardFragment standardFragment = StandardFragmentProcessor.computeStandardFragmentSpec((Configuration)configuration, (IProcessingContext)processingContext, (String)templateSelector, (String)tilesDialectPrefix, (String)"fragment");
        return new TilesFragment(standardFragment);
    }

    private static boolean isStandardDialectPresent(TemplateEngine templateEngine) {
        Class<?> springStandardDialectClass;
        try {
            springStandardDialectClass = Class.forName(SPRING3_STANDARD_DIALECT_CLASS_NAME);
            if (ThymeleafAttributeRenderer.isDialectPresent(templateEngine, springStandardDialectClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            springStandardDialectClass = Class.forName(SPRING4_STANDARD_DIALECT_CLASS_NAME);
            if (ThymeleafAttributeRenderer.isDialectPresent(templateEngine, springStandardDialectClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ThymeleafAttributeRenderer.isDialectPresent(templateEngine, StandardDialect.class);
    }

    private static boolean isDialectPresent(TemplateEngine templateEngine, Class<?> dialectClass) {
        for (IDialect dialect : templateEngine.getDialects()) {
            if (!dialectClass.isAssignableFrom(dialect.getClass())) continue;
            return true;
        }
        return false;
    }

    private static TilesFragment computeNonStandardFragment(TemplateEngine templateEngine, String templateSelector) {
        if (templateSelector.trim().endsWith(")")) {
            throw new TemplateProcessingException("Cannot process template selector \"" + templateSelector + "\": The Thymeleaf Standard Dialect " + "has not been enabled, and therefore no parameters can be allowed for fragments.");
        }
        int separatorPos = templateSelector.indexOf("::");
        if (separatorPos < 0) {
            return new TilesFragment(templateSelector, (IFragmentSpec)WholeFragmentSpec.INSTANCE);
        }
        String templateName = templateSelector.substring(0, separatorPos).trim();
        String fragmentSelector = templateSelector.substring(separatorPos + 2).trim();
        if (fragmentSelector.length() > 3 && fragmentSelector.charAt(0) == '[' && fragmentSelector.charAt(fragmentSelector.length() - 1) == ']' && fragmentSelector.charAt(fragmentSelector.length() - 2) != '\'') {
            fragmentSelector = fragmentSelector.substring(1, fragmentSelector.length() - 1);
        }
        String tilesDialectPrefix = ThymeleafAttributeRenderer.getTilesDialectPrefix(templateEngine);
        StandardFragmentSignatureNodeReferenceChecker nodeReferenceChecker = new StandardFragmentSignatureNodeReferenceChecker(templateEngine.getConfiguration(), tilesDialectPrefix, "fragment");
        DOMSelectorFragmentSpec fragmentSpec = new DOMSelectorFragmentSpec(fragmentSelector, (DOMSelector.INodeReferenceChecker)nodeReferenceChecker);
        return new TilesFragment(templateName, (IFragmentSpec)fragmentSpec);
    }

    private static String getTilesDialectPrefix(TemplateEngine templateEngine) {
        for (Map.Entry dialectByPrefix : templateEngine.getDialectsByPrefix().entrySet()) {
            IDialect dialect = (IDialect)dialectByPrefix.getValue();
            if (!TilesDialect.class.isAssignableFrom(dialect.getClass())) continue;
            return (String)dialectByPrefix.getKey();
        }
        throw new ConfigurationException("Tiles dialect has not been found. In order to use Apache Tiles with Thymeleaf, you should configure the " + TilesDialect.class.getName() + " dialect at your Template Engine");
    }

    public boolean isRenderable(Object value, Attribute attribute, TilesRequestContext request) {
        return true;
    }
}

