/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.spring4.web.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.servlet.context.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.util.StringUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.extras.tiles2.context.ThymeleafTilesRequestContextFactory;
import org.thymeleaf.extras.tiles2.spring4.web.configurer.ThymeleafTilesConfigurer;
import org.thymeleaf.extras.tiles2.spring4.web.view.ThymeleafTilesView;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.AjaxEnabledView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxThymeleafTilesView
extends ThymeleafTilesView
implements AjaxEnabledView {
    private static final Logger vlogger = LoggerFactory.getLogger(AjaxThymeleafTilesView.class);
    private static final String FRAGMENTS_PARAM = "fragments";
    private final ThymeleafTilesRequestContextFactory tilesRequestContextFactory = new ThymeleafTilesRequestContextFactory();
    private AjaxHandler ajaxHandler = null;

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    @Override
    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxHandler templateAjaxHandler = this.getAjaxHandler();
        if (templateAjaxHandler == null) {
            throw new ConfigurationException("[THYMELEAF] AJAX Handler set into " + AjaxThymeleafTilesView.class.getSimpleName() + " instance for template " + this.getTemplateName() + " is null.");
        }
        if (templateAjaxHandler.isAjaxRequest(request, response)) {
            String[] fragmentsToRender = this.getRenderFragments(model, request, response);
            if (fragmentsToRender.length == 0) {
                vlogger.warn("[THYMELEAF] An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.render(model, request, response);
                return;
            }
            ServletContext servletContext = this.getServletContext();
            if (this.getTemplateEngine() == null) {
                throw new IllegalArgumentException("Property 'templateEngine' is required");
            }
            if (this.getTemplateName() == null) {
                throw new IllegalArgumentException("Property 'templateName' is required");
            }
            SpringTemplateEngine viewTemplateEngine = this.getTemplateEngine();
            IProcessingContext processingContext = this.buildContextAndPrepareResponse((TemplateEngine)viewTemplateEngine, model, request, response);
            BasicTilesContainer container = (BasicTilesContainer)ServletUtil.getContainer((ServletContext)servletContext);
            if (container == null) {
                throw new ServletException("Tiles container is not initialized. Have you added a " + ThymeleafTilesConfigurer.class.getSimpleName() + " to " + "your web application context?");
            }
            TilesRequestContext tilesRequestContext = this.tilesRequestContextFactory.createRequestContext(container.getApplicationContext(), new Object[]{viewTemplateEngine, processingContext, request, response, response.getWriter()});
            Definition compositeDefinition = container.getDefinitionsFactory().getDefinition(this.getTemplateName(), tilesRequestContext);
            HashMap<String, Attribute> flattenedAttributeMap = new HashMap<String, Attribute>();
            this.flattenAttributeMap(container, tilesRequestContext, flattenedAttributeMap, compositeDefinition, request, response);
            this.addRuntimeAttributes(container, flattenedAttributeMap, request, response);
            if (fragmentsToRender.length > 1) {
                request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", (Object)Boolean.TRUE);
            }
            for (int i = 0; i < fragmentsToRender.length; ++i) {
                Attribute attributeToRender = (Attribute)flattenedAttributeMap.get(fragmentsToRender[i]);
                if (attributeToRender == null) {
                    throw new ServletException("No tiles attribute with a name of '" + fragmentsToRender[i] + "' could be found for the current view: " + (Object)((Object)this));
                }
                container.startContext(new Object[]{request, response}).inheritCascadedAttributes((AttributeContext)compositeDefinition);
                container.render(attributeToRender, new Object[]{request, response});
                container.endContext(new Object[]{request, response});
            }
        } else {
            super.render(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map model, HttpServletRequest request, HttpServletResponse response) {
        String fragmentsParam = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)fragmentsParam);
        return StringUtils.trimArrayElements((String[])renderFragments);
    }

    protected void flattenAttributeMap(BasicTilesContainer container, TilesRequestContext requestContext, Map<String, Attribute> resultMap, Definition compositeDefinition, HttpServletRequest request, HttpServletResponse response) {
        Iterator iterator = compositeDefinition.getAttributeNames();
        while (iterator.hasNext()) {
            String attributeName = (String)iterator.next();
            Attribute attribute = compositeDefinition.getAttribute(attributeName);
            if (attribute.getValue() == null || !(attribute.getValue() instanceof String)) continue;
            resultMap.put(attributeName, attribute);
            String value = attribute.getValue().toString();
            if (!container.isValidDefinition(value, new Object[]{request, response})) continue;
            Definition nestedDefinition = container.getDefinitionsFactory().getDefinition(value, requestContext);
            this.flattenAttributeMap(container, requestContext, resultMap, nestedDefinition, request, response);
        }
    }

    protected void addRuntimeAttributes(BasicTilesContainer container, Map<String, Attribute> resultMap, HttpServletRequest request, HttpServletResponse response) {
        AttributeContext attributeContext = container.getAttributeContext(new Object[]{request, response});
        HashSet attributeNames = new HashSet();
        if (attributeContext.getLocalAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getLocalAttributeNames());
        }
        if (attributeContext.getCascadedAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getCascadedAttributeNames());
        }
        for (String attributeName : attributeNames) {
            resultMap.put(attributeName, attributeContext.getAttribute(attributeName));
        }
    }
}

