/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.extras.springsecurity5.auth.AuthUtils;

public final class AclAuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(AclAuthUtils.class);

    private AclAuthUtils() {
    }

    public static boolean authorizeUsingAccessControlList(IExpressionContext context, Object domainObject, ApplicationContext applicationContext, String permissionsString, Authentication authentication) {
        List<Permission> permissions = AclAuthUtils.parsePermissionsString(applicationContext, permissionsString);
        return AclAuthUtils.authorizeUsingAccessControlList(context, domainObject, permissions, authentication);
    }

    public static boolean authorizeUsingAccessControlList(IExpressionContext context, Object domainObject, List<Permission> permissions, Authentication authentication) {
        ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checking authorization using Access Control List for user \"{}\". Domain object is of class \"{}\" and permissions are \"{}\".", new Object[]{TemplateEngine.threadIndex(), authentication == null ? null : authentication.getName(), domainObject == null ? null : domainObject.getClass().getName(), permissions});
        }
        ApplicationContext applicationContext = AuthUtils.getContext((IContext)context);
        AclService aclService = AclAuthUtils.getBeanOfType(applicationContext, AclService.class);
        if (authentication == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Authentication object is null. Access is DENIED. ", new Object[]{TemplateEngine.threadIndex()});
            }
            return false;
        }
        SidRetrievalStrategy sidRetrievalStrategy = AclAuthUtils.getBeanOfType(applicationContext, SidRetrievalStrategy.class);
        if (sidRetrievalStrategy == null) {
            sidRetrievalStrategy = new SidRetrievalStrategyImpl();
        }
        if ((objectIdentityRetrievalStrategy = AclAuthUtils.getBeanOfType(applicationContext, ObjectIdentityRetrievalStrategy.class)) == null) {
            objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
        }
        if (null == permissions || permissions.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Permissions are null or empty. Access is DENIED. ", new Object[]{TemplateEngine.threadIndex()});
            }
            return false;
        }
        if (domainObject == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Domain object for resolved to null. Access by Access Control List is GRANTED.", new Object[]{TemplateEngine.threadIndex()});
            }
            return true;
        }
        List sids = sidRetrievalStrategy.getSids(SecurityContextHolder.getContext().getAuthentication());
        ObjectIdentity oid = objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        try {
            Acl acl = aclService.readAclById(oid, sids);
            if (acl.isGranted(permissions, sids, false)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}] Checked authorization using Access Control List for user \"{}\". Domain object is of class \"{}\" and permissions are \"{}\". Access is GRANTED.", new Object[]{TemplateEngine.threadIndex(), authentication.getName(), domainObject.getClass().getName(), permissions});
                }
                return true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Checked authorization using Access Control List for user \"{}\". Domain object is of class \"{}\" and permissions are \"{}\". Access is DENIED.", new Object[]{TemplateEngine.threadIndex(), authentication.getName(), domainObject.getClass().getName(), permissions});
            }
            return false;
        }
        catch (NotFoundException nfe) {
            return false;
        }
    }

    public static List<Permission> parsePermissionsString(ApplicationContext applicationContext, String permissionsString) throws NumberFormatException {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Parsing permissions string \"{}\".", new Object[]{TemplateEngine.threadIndex(), permissionsString});
        }
        if (permissionsString == null || permissionsString.trim().length() == 0) {
            return Collections.emptyList();
        }
        PermissionFactory permissionFactory = AclAuthUtils.getBeanOfType(applicationContext, PermissionFactory.class);
        if (permissionFactory == null) {
            permissionFactory = new DefaultPermissionFactory();
        }
        HashSet<Permission> permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(permissionsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String permission = tokenizer.nextToken();
            try {
                permissions.add(permissionFactory.buildFromMask(Integer.valueOf(permission).intValue()));
            }
            catch (NumberFormatException nfe) {
                permissions.add(permissionFactory.buildFromName(permission));
            }
        }
        return new ArrayList<Permission>(permissions);
    }

    private static <T> T getBeanOfType(ApplicationContext applicationContext, Class<T> type) {
        Map map = applicationContext.getBeansOfType(type);
        for (ApplicationContext context = applicationContext.getParent(); context != null; context = context.getParent()) {
            map.putAll(context.getBeansOfType(type));
        }
        if (map.size() == 0) {
            return null;
        }
        if (map.size() == 1) {
            return (T)map.values().iterator().next();
        }
        throw new ConfigurationException("Found incorrect number of " + type.getSimpleName() + " instances in application context - you must have only have one!");
    }
}

