/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.api;

import org.terracotta.api.ClusteringToolkit;
import org.terracotta.express.Client;
import org.terracotta.express.ClientFactory;
import org.terracotta.express.ClientFactoryExtras;

public class TerracottaClient {
    private final ClusteringToolkit toolkit;
    private final Client client;

    public TerracottaClient(String terracottaConfigUrl) {
        this(terracottaConfigUrl, false);
    }

    public TerracottaClient(String terracottaConfigUrl, boolean dedicatedClient) {
        if (terracottaConfigUrl == null) {
            throw new NullPointerException("terracottaConfigUrl cannot be null");
        }
        this.client = this.newClient(terracottaConfigUrl, dedicatedClient);
        try {
            this.toolkit = (ClusteringToolkit)this.client.instantiate("org.terracotta.api.TerracottaToolkit", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Terracotta clustering toolkit", e);
        }
    }

    protected Client newClient(String terracottaConfigUrl, boolean dedicatedClient) {
        if (dedicatedClient) {
            return ClientFactoryExtras.createDedicatedClient(terracottaConfigUrl, true, new Class[]{this.getClass()});
        }
        return ClientFactory.getOrCreateClient(terracottaConfigUrl, true, new Class[]{this.getClass()});
    }

    public ClusteringToolkit getToolkit() {
        return this.toolkit;
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

