/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class CanonicalStringSet
extends AbstractSet {
    private final char separator;
    private final SortedMap map = new TreeMap();

    public CanonicalStringSet(char separator) {
        this.separator = separator;
    }

    public CanonicalStringSet(char separator, CanonicalStringSet set) {
        this.separator = separator;
        if (set != null) {
            this.addAll(set);
        }
    }

    public CanonicalStringSet(char separator, String list) {
        this.separator = separator;
        if (list != null) {
            this.addAll(list);
        }
    }

    protected String canonical(String s) {
        return this.canonicalize(s);
    }

    protected String canonicalize(String s) {
        assert (s != null);
        assert (s.indexOf(this.separator) < 0) : "separator in string is illegal";
        return s;
    }

    @Override
    public final boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean contains(Object list) {
        return this.containsAll((String)list);
    }

    @Override
    public final Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public final Iterator originalIterator() {
        return this.map.values().iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public final Object[] toArray(Object[] array) {
        return this.map.keySet().toArray(array);
    }

    @Override
    public final boolean add(Object list) {
        return this.addAll((String)list);
    }

    @Override
    public final boolean remove(Object list) {
        return this.removeAll((String)list);
    }

    public final boolean containsAll(CanonicalStringSet set) {
        return this.map.keySet().containsAll(set.map.keySet());
    }

    public final boolean containsAll(String list) {
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            if (this.map.containsKey(i.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean addAll(CanonicalStringSet set) {
        return super.addAll(set);
    }

    public final boolean addAll(String list) {
        boolean changed = false;
        StringIterator i = new StringIterator(list);
        while (i.hasNext()) {
            String element = (String)i.next();
            String canonical = this.canonicalize(element);
            if (canonical == null) continue;
            String previous = this.map.put(canonical, element);
            if (changed) continue;
            changed = previous == null || !element.equals(previous);
        }
        return changed;
    }

    public final boolean retainAll(CanonicalStringSet set) {
        return this.map.keySet().retainAll(set.map.keySet());
    }

    public final boolean retainAll(final String list) {
        class CustomSet
        extends CanonicalStringSet {
            CustomSet() {
                super(CanonicalStringSet.this.separator);
                super.addAll(list);
            }

            @Override
            protected String canonicalize(String s) {
                return CanonicalStringSet.this.canonicalize(s);
            }
        }
        return this.map.keySet().retainAll(new CustomSet());
    }

    public final boolean removeAll(CanonicalStringSet set) {
        return this.map.keySet().removeAll(set.map.keySet());
    }

    public final boolean removeAll(String list) {
        boolean changed = false;
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            changed |= this.map.remove(i.next()) != null;
        }
        return changed;
    }

    @Override
    public final void clear() {
        this.map.clear();
    }

    @Override
    public final String toString() {
        Iterator i = this.iterator();
        if (i.hasNext()) {
            StringBuffer sb = new StringBuffer();
            int c = 0;
            do {
                String string = (String)i.next();
                if (c++ > 0) {
                    sb.append(this.separator);
                }
                sb.append(string);
            } while (i.hasNext());
            return sb.toString();
        }
        return "";
    }

    private class StringIterator
    implements Iterator {
        private final String[] split;
        private int i = 0;

        private StringIterator(String list) {
            this.split = list.split("\\" + CanonicalStringSet.this.separator);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.split.length;
        }

        public Object next() {
            try {
                return this.split[this.i++];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CanonicalStringIterator
    implements Iterator {
        private final Iterator i;
        private String canonical;

        private CanonicalStringIterator(String list) {
            this.i = new StringIterator(list);
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.canonical != null;
        }

        public Object next() {
            if (this.canonical == null) {
                throw new NoSuchElementException();
            }
            String c = this.canonical;
            this.advance();
            return c;
        }

        private void advance() {
            while (this.i.hasNext()) {
                this.canonical = CanonicalStringSet.this.canonicalize((String)this.i.next());
                if (this.canonical == null) continue;
                return;
            }
            this.canonical = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

