/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.key;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyManager;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.UnknownKeyException;
import org.terracotta.agent.repkg.de.schlichtherle.util.ThreadLocalLong;

public abstract class AbstractKeyProvider
implements KeyProvider {
    private Object key;
    private final ThreadLocalLong invalidated = new ThreadLocalLong();

    public synchronized Object getKey() {
        return this.key;
    }

    public synchronized void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getCreateKey() throws UnknownKeyException {
        Object key = this.getCreateKeyImpl();
        if (key == null) {
            throw new UnknownKeyException();
        }
        return AbstractKeyProvider.clone(key);
    }

    protected Object getCreateKeyImpl() throws UnknownKeyException {
        return this.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getOpenKey() throws UnknownKeyException {
        try {
            Object key = this.getOpenKeyImpl();
            if (key == null) {
                throw new UnknownKeyException();
            }
            Object object = AbstractKeyProvider.clone(key);
            return object;
        }
        finally {
            this.enforceSuspensionPenalty();
        }
    }

    protected Object getOpenKeyImpl() throws UnknownKeyException {
        return this.getKey();
    }

    @Override
    public final void invalidOpenKey() {
        this.invalidated.setValue(System.currentTimeMillis());
        this.invalidOpenKeyImpl();
    }

    protected abstract void invalidOpenKeyImpl();

    public void reset() {
    }

    protected Object cloneKey() {
        Object key = this.getKey();
        if (key == null) {
            return null;
        }
        return AbstractKeyProvider.clone(key);
    }

    static Object clone(Object key) {
        Class<?> c = key.getClass();
        if (c.isArray()) {
            int l = Array.getLength(key);
            Object p = Array.newInstance(c.getComponentType(), l);
            System.arraycopy(key, 0, p, 0, l);
            return p;
        }
        try {
            return key.getClass().getMethod("clone", null).invoke(key, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetKey() {
        Object key = this.getKey();
        if (key == null) {
            return;
        }
        this.setKey(null);
        Object object = key;
        synchronized (object) {
            if (key instanceof byte[]) {
                Arrays.fill((byte[])key, (byte)0);
            } else if (key instanceof char[]) {
                Arrays.fill((char[])key, '\u0000');
            } else if (key instanceof short[]) {
                Arrays.fill((short[])key, (short)0);
            } else if (key instanceof int[]) {
                Arrays.fill((int[])key, 0);
            } else if (key instanceof long[]) {
                Arrays.fill((long[])key, 0L);
            } else if (key instanceof float[]) {
                Arrays.fill((float[])key, 0.0f);
            } else if (key instanceof double[]) {
                Arrays.fill((double[])key, 0.0);
            } else if (key instanceof boolean[]) {
                Arrays.fill((boolean[])key, false);
            } else if (key instanceof Object[]) {
                Arrays.fill((Object[])key, null);
            }
        }
    }

    private void enforceSuspensionPenalty() {
        long delay;
        long last = this.invalidated.getValue();
        InterruptedException interrupted = null;
        while ((delay = System.currentTimeMillis() - last) < 3000L) {
            try {
                Thread.sleep(3000L - delay);
            }
            catch (InterruptedException ex) {
                interrupted = ex;
            }
        }
        if (interrupted != null) {
            Thread.currentThread().interrupt();
        }
    }

    protected KeyProvider addToKeyManager(String resourceID) throws NullPointerException, IllegalStateException {
        return KeyManager.mapKeyProvider(resourceID, this);
    }

    protected KeyProvider removeFromKeyManager(String resourceID) throws NullPointerException, IllegalStateException {
        return KeyManager.unmapKeyProvider(resourceID);
    }
}

