/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.rof;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.AbstractReadOnlyFile;

public class ChannelReadOnlyFile
extends AbstractReadOnlyFile {
    private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
    private final FileChannel channel;

    public ChannelReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
    }

    @Override
    public long length() throws IOException {
        return this.channel.size();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.channel.position();
    }

    @Override
    public void seek(long fp) throws IOException {
        try {
            this.channel.position(fp);
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException(iae.toString());
            ioe.initCause(iae);
            throw ioe;
        }
    }

    @Override
    public int read() throws IOException {
        this.singleByteBuffer.position(0);
        if (this.channel.read(this.singleByteBuffer) == 1) {
            return this.singleByteBuffer.array()[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.channel.read(ByteBuffer.wrap(buf, off, len));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

