/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.OutputArchiveMetaData;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.OutputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.RfsEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32Entry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.Temps;
import org.terracotta.agent.repkg.de.schlichtherle.util.JointEnumeration;
import org.terracotta.agent.repkg.de.schlichtherle.util.zip.BasicZipOutputStream;

public class Zip32OutputArchive
extends BasicZipOutputStream
implements OutputArchive {
    private static final String TEMP_FILE_PREFIX = "tzp-zip";
    private final Zip32InputArchive source;
    private OutputArchiveMetaData metaData;
    private Zip32Entry tempEntry;

    public Zip32OutputArchive(OutputStream out, String charset, Zip32InputArchive source) throws NullPointerException, UnsupportedEncodingException, IOException {
        this(out, charset, 9, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zip32OutputArchive(OutputStream out, String charset, int level, Zip32InputArchive source) throws NullPointerException, UnsupportedEncodingException, IOException {
        super(out, charset);
        super.setLevel(level);
        this.source = source;
        if (source != null) {
            super.setComment(source.getComment());
            if (source.getPreambleLength() > 0L) {
                InputStream in = source.getPreambleInputStream();
                try {
                    File.cat(in, source.offsetsConsiderPreamble() ? this : out);
                }
                finally {
                    in.close();
                }
            }
        }
    }

    @Override
    public int getNumArchiveEntries() {
        return this.size() + (this.tempEntry != null ? 1 : 0);
    }

    @Override
    public Enumeration getArchiveEntries() {
        if (this.tempEntry == null) {
            return super.entries();
        }
        return new JointEnumeration(super.entries(), Collections.enumeration(Collections.singletonList(this.tempEntry)));
    }

    @Override
    public ArchiveEntry getArchiveEntry(String entryName) {
        Zip32Entry e = (Zip32Entry)this.getEntry(entryName);
        if (e != null) {
            return e;
        }
        e = this.tempEntry;
        return e != null && entryName.equals(e.getName()) ? e : null;
    }

    @Override
    public OutputStream getOutputStream(ArchiveEntry dstEntry, ArchiveEntry srcEntry) throws IOException {
        Zip32Entry entry = (Zip32Entry)dstEntry;
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(entry);
        }
        if (entry.isDirectory()) {
            entry.setMethod(0);
            entry.setCrc(0L);
            entry.setCompressedSize(0L);
            entry.setSize(0L);
            return new EntryOutputStream(entry);
        }
        if (srcEntry instanceof Zip32Entry) {
            Zip32Entry srcZipEntry = (Zip32Entry)srcEntry;
            if (entry.getMethod() == -1) {
                entry.setMethod(srcZipEntry.getMethod());
            }
            if (entry.getMethod() == srcZipEntry.getMethod()) {
                entry.setCompressedSize(srcZipEntry.getCompressedSize());
            }
            entry.setCrc(srcZipEntry.getCrc());
            entry.setSize(srcZipEntry.getSize());
            return new EntryOutputStream(entry, srcZipEntry.getMethod() != 8);
        }
        if (srcEntry != null) {
            entry.setSize(srcEntry.getSize());
        }
        switch (entry.getMethod()) {
            case -1: {
                entry.setMethod(8);
                break;
            }
            case 0: {
                if (entry.getCrc() != -1L && entry.getCompressedSize() != -1L && entry.getSize() != -1L) break;
                if (!(srcEntry instanceof RfsEntry)) {
                    java.io.File temp = Temps.createTempFile(TEMP_FILE_PREFIX);
                    return new TempEntryOutputStream(entry, temp);
                }
                java.io.File file = ((RfsEntry)srcEntry).getFile();
                long length = file.length();
                if (length > Integer.MAX_VALUE) {
                    throw new IOException("file too large");
                }
                FileInputStream in = new FileInputStream(file);
                Crc32OutputStream out = new Crc32OutputStream();
                File.cp(in, out);
                entry.setCrc(out.crc.getValue());
                entry.setCompressedSize(length);
                entry.setSize(length);
                break;
            }
            case 8: {
                break;
            }
            default: {
                assert (false) : "unsupported method";
                break;
            }
        }
        return new EntryOutputStream(entry);
    }

    @Override
    public final boolean isBusy() {
        return super.isBusy() || this.tempEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(Zip32Entry entry, java.io.File temp) throws IOException {
        assert (entry.getMethod() == 0);
        assert (entry.getCrc() != -1L);
        assert (entry.getCompressedSize() != -1L);
        assert (entry.getSize() != -1L);
        try {
            FileInputStream in = new FileInputStream(temp);
            try {
                this.putNextEntry(entry);
                try {
                    File.cat(in, this);
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        finally {
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    @Override
    public final void storeDirectory(ArchiveEntry entry) throws IOException {
        assert (false) : "Since TrueZIP 6.5, this is not used anymore!";
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(entry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        super.finish();
        if (this.source == null) {
            return;
        }
        long ipl = this.source.getPostambleLength();
        if (ipl <= 0L) {
            return;
        }
        long il = this.source.length();
        long ol = this.length();
        InputStream in = this.source.getPostambleInputStream();
        try {
            if (ol + ipl != il) {
                this.write(new byte[(int)(ol % 4L)]);
            }
            File.cat(in, this);
        }
        finally {
            in.close();
        }
    }

    @Override
    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void setMetaData(OutputArchiveMetaData metaData) {
        this.metaData = metaData;
    }

    private static class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc = new CRC32();

        private Crc32OutputStream() {
        }

        @Override
        public void write(int b) {
            this.crc.update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.crc.update(b, off, len);
        }
    }

    private class TempEntryOutputStream
    extends CheckedOutputStream {
        private final java.io.File temp;
        private boolean closed;

        public TempEntryOutputStream(Zip32Entry entry, java.io.File temp) throws IOException {
            super(new FileOutputStream(temp), new CRC32());
            assert (entry.getMethod() == 0);
            this.temp = temp;
            Zip32OutputArchive.this.tempEntry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long length = this.temp.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("file too large");
                    }
                    Zip32OutputArchive.this.tempEntry.setCrc(this.getChecksum().getValue());
                    Zip32OutputArchive.this.tempEntry.setCompressedSize(length);
                    Zip32OutputArchive.this.tempEntry.setSize(length);
                    Zip32OutputArchive.this.storeTempEntry(Zip32OutputArchive.this.tempEntry, this.temp);
                }
            }
            finally {
                Zip32OutputArchive.this.tempEntry = null;
            }
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private EntryOutputStream(Zip32Entry entry) throws IOException {
            this(entry, true);
        }

        private EntryOutputStream(Zip32Entry entry, boolean deflate) throws IOException {
            super(Zip32OutputArchive.this);
            Zip32OutputArchive.this.putNextEntry(entry, deflate);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            Zip32OutputArchive.this.closeEntry();
        }
    }
}

