/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi;

import java.io.File;
import javax.swing.Icon;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveEntryMetaData;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;

public class RfsEntry
implements ArchiveEntry {
    private final String entryName;
    private final File file;

    public RfsEntry(File file) {
        this(file, RfsEntry.getName(file));
    }

    public RfsEntry(File file, String entryName) {
        if (entryName == null || file == null) {
            throw new NullPointerException();
        }
        this.entryName = entryName;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String getName(File file) {
        String entryName = file.getPath().replace(File.separatorChar, '/');
        if (file.isDirectory()) {
            return entryName + '/';
        }
        return entryName;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getTime() {
        return this.file.lastModified();
    }

    @Override
    public void setTime(long time) {
        this.file.setLastModified(time);
    }

    @Override
    public Icon getOpenIcon() {
        return null;
    }

    @Override
    public Icon getClosedIcon() {
        return null;
    }

    @Override
    public ArchiveEntryMetaData getMetaData() {
        return null;
    }

    @Override
    public void setMetaData(ArchiveEntryMetaData metaData) {
    }
}

