/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveEntryStreamClosedException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveWarningException;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.Archive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.SynchronizedInputStream;

public final class InputArchiveMetaData {
    private static final String CLASS_NAME = "de/schlichtherle/io/InputArchiveMetaData".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final Archive archive;
    private final InputArchive inArchive;
    private final Map streams;
    private volatile boolean stopped;

    InputArchiveMetaData(Archive archive, InputArchive inArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        assert (inArchive != null);
        this.archive = archive;
        this.inArchive = inArchive;
    }

    synchronized InputStream createInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        assert (!this.stopped);
        assert (entry != null);
        InputStream in = this.inArchive.getInputStream(entry, dstEntry);
        return in != null ? new EntryInputStream(in) : null;
    }

    synchronized int waitAllInputStreamsByOtherThreads(long timeout) {
        assert (!this.stopped);
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.streams.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(toWait);
            }
        }
        catch (InterruptedException ignored) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        for (Thread thread : this.streams.values()) {
            if (thisThread != thread) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllInputStreams(ArchiveException exceptionChain) {
        assert (!this.stopped);
        this.stopped = true;
        for (EntryInputStream in : this.streams.keySet()) {
            try {
                in.doClose();
            }
            catch (IOException failure) {
                exceptionChain = new ArchiveWarningException(exceptionChain, failure);
            }
        }
        this.streams.clear();
        return exceptionChain;
    }

    private final class EntryInputStream
    extends SynchronizedInputStream {
        private boolean closed;

        private EntryInputStream(InputStream in) {
            super(in, InputArchiveMetaData.this);
            assert (in != null);
            InputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            InputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (InputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        @Override
        public int read() throws IOException {
            this.ensureNotStopped();
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.ensureNotStopped();
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureNotStopped();
            return super.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureNotStopped();
            return super.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.ensureNotStopped();
            return super.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            assert (InputArchiveMetaData.this == this.lock);
            InputArchiveMetaData inputArchiveMetaData = InputArchiveMetaData.this;
            synchronized (inputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    InputArchiveMetaData.this.streams.remove(this);
                    InputArchiveMetaData.this.notify();
                }
            }
        }

        @Override
        protected void doClose() throws IOException {
            assert (!this.closed);
            this.closed = true;
            super.doClose();
        }

        @Override
        public void mark(int readlimit) {
            if (!InputArchiveMetaData.this.stopped) {
                super.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            this.ensureNotStopped();
            super.reset();
        }

        @Override
        public boolean markSupported() {
            return !InputArchiveMetaData.this.stopped && super.markSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException failure) {
                    logger.log(Level.FINE, "finalize.exception", failure);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

