/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express.loader;

import com.terracotta.express.loader.ByteArrayReadOnlyFile;
import com.terracotta.express.loader.JarManager;
import com.terracotta.express.loader.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32InputArchive;

public class Jar {
    private static final long NOT_INITIALIZED = -1L;
    private final ReentrantLock lock = new ReentrantLock();
    private final URL source;
    private final JarManager jarManager;
    private long lastAccess = -1L;
    private Zip32InputArchive archive;
    private byte[] contents;

    Jar(URL source, JarManager jarManager) {
        this.source = source;
        this.jarManager = jarManager;
    }

    public URL getSource() {
        return this.source;
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeflated() {
        this.lock();
        try {
            boolean bl = this.archive == null && this.contents == null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deflateIfIdle(long idle) {
        this.lock();
        try {
            if (this.lastAccess == -1L || this.archive == null) {
                boolean bl = true;
                return bl;
            }
            if (System.currentTimeMillis() - this.lastAccess > idle) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.contents = null;
                this.archive = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResource(String res) throws IOException {
        this.lock();
        try {
            this.touch();
            boolean bl = this.archive.getArchiveEntry(res) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private void touch() throws IOException {
        this.lastAccess = System.currentTimeMillis();
        this.inflateIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lookup(String resource) throws IOException {
        this.lock();
        try {
            this.touch();
            InputStream in = this.archive.getInputStream(resource);
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Util.extract(in);
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] contents() throws IOException {
        this.lock();
        try {
            this.touch();
            byte[] byArray = this.contents;
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    private void inflateIfNeeded() throws IOException {
        if (this.archive == null) {
            String extForm = this.source.toExternalForm();
            if (extForm.startsWith("jar:jar:")) {
                int nesting = Util.getNumJarSeparators(extForm);
                if (nesting > 2) {
                    throw new IOException("Cannot handle more than 3 levels of nested jar lookups");
                }
                if (nesting <= 0) {
                    throw new MalformedURLException("No '!/' found in URL beginning with 'jar:'");
                }
                extForm = extForm.substring("jar:".length());
                String secondJarUrl = extForm.substring(0, extForm.lastIndexOf("!/"));
                String resourceInSecondJar = extForm.substring(extForm.lastIndexOf("!/") + "!/".length());
                if (resourceInSecondJar.startsWith("/")) {
                    resourceInSecondJar = resourceInSecondJar.substring(1);
                }
                Jar secondJar = this.jarManager.getOrCreate(secondJarUrl, new URL(secondJarUrl));
                this.contents = secondJar.lookup(resourceInSecondJar);
            } else {
                this.contents = Util.extract(this.source.openStream());
            }
            this.archive = new Zip32InputArchive(new ByteArrayReadOnlyFile(this.contents), "UTF-8", false, false);
            this.jarManager.jarOpened(this);
        }
    }

    public String toString() {
        return this.source.toExternalForm();
    }
}

