/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.util.Assert;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLConfigUtil {
    private static Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
    private static TCLogger logger = TCLogging.getLogger(URLConfigUtil.class);

    public static String translateSystemProperties(String urlConfig) {
        String[] urlConfigSources;
        String rv = "";
        for (String source : urlConfigSources = urlConfig.split(",")) {
            Assert.assertNotNull((Object)source);
            source = source.trim();
            Set<String> properties = URLConfigUtil.extractPropertyTokens(source);
            for (String token : properties) {
                String leftTrimmed = token.replaceAll("\\$\\{", "");
                String trimmedToken = leftTrimmed.replaceAll("\\}", "");
                String property = System.getProperty(trimmedToken);
                if (property == null) {
                    logger.error((Object)("Did not find a system property for the " + token + " token specified in the configuration.Replacing with \"\""));
                    continue;
                }
                String propertyWithQuotesProtected = Matcher.quoteReplacement(property);
                source = source.replaceAll("\\$\\{" + trimmedToken + "\\}", propertyWithQuotesProtected);
                logger.info((Object)("Found system property value of " + property + " for the " + token + " token specified in the configuration."));
            }
            if (source == null) continue;
            rv = rv + (rv == "" ? "" : ", ") + source;
        }
        return rv;
    }

    static Set<String> extractPropertyTokens(String sourceString) {
        HashSet<String> propertyTokens = new HashSet<String>();
        Matcher matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            String token = matcher.group();
            propertyTokens.add(token);
        }
        return propertyTokens;
    }

    public static String getUsername(String embeddedTcConfig) {
        String translated = URLConfigUtil.translateSystemProperties(embeddedTcConfig);
        String[] split = translated.split(",");
        String username = null;
        for (String s : split) {
            int index = s.indexOf(64);
            if (index == -1) continue;
            if (username != null) {
                Assert.assertEquals((Object)username, (Object)s.substring(0, index).trim());
            }
            username = s.substring(0, index).trim();
        }
        return username;
    }
}

