/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.google.common.collect.MapMaker;
import com.tc.config.schema.beanfactory.ConfigBeanFactory;
import com.tc.config.schema.beanfactory.TerracottaDomainConfigurationDocumentBeanFactory;
import com.tc.config.schema.repository.ApplicationsRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.repository.StandardApplicationsRepository;
import com.tc.config.schema.repository.StandardBeanRepository;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.ConfigurationSpec;
import com.tc.config.schema.setup.StandardConfigurationSetupManagerFactory;
import com.tc.config.schema.setup.StandardXMLFileConfigurationCreator;
import com.tc.license.LicenseManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.core.SecurityInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.object.bytecode.hook.DSOContext;
import com.tc.object.bytecode.hook.impl.DSOContextImpl;
import com.tc.security.PwProvider;
import com.tc.util.ProductInfo;
import com.terracotta.express.URLConfigUtil;
import com.terracottatech.config.Client;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import com.terracottatech.config.TcConfigDocument;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlException;

public class StandaloneL1Boot
implements Callable<Object> {
    private static TCLogger logger;
    private final Map<String, URL> virtualTimJars;
    private final Collection<URL> additionalModules;
    private final String embeddedTcConfig;
    private final boolean isURLConfig;
    private final ClassLoader appLevelTimLoader;
    private final String toolkitApiVersion;
    private final URL bootJarUrl;
    private final boolean rejoin;
    private final SecurityInfo securityInfo;
    private final Map<String, Object> env;

    public StandaloneL1Boot(Map<String, URL> virtualTimJars, Collection<URL> additionalModules, String embeddedTcConfig, boolean isURLConfig, ClassLoader appLevelTimLoader, URL bootJarUrl, boolean rejoin, Map<String, Object> env) {
        this.virtualTimJars = virtualTimJars;
        this.additionalModules = additionalModules;
        this.embeddedTcConfig = embeddedTcConfig;
        this.isURLConfig = isURLConfig;
        String username = null;
        if (isURLConfig) {
            username = URLConfigUtil.getUsername(embeddedTcConfig);
        }
        this.securityInfo = new SecurityInfo(username != null, username);
        this.appLevelTimLoader = appLevelTimLoader;
        this.bootJarUrl = bootJarUrl;
        this.toolkitApiVersion = StandaloneL1Boot.inferToolkitVersion(virtualTimJars);
        this.rejoin = rejoin;
        this.env = env;
    }

    private static String inferToolkitVersion(Map<String, URL> timJars) {
        String prefix = "terracotta-toolkit-";
        for (String tim : timJars.keySet()) {
            if (!tim.startsWith(prefix)) continue;
            Pattern apiVer = Pattern.compile("^(\\d+\\.\\d+).*$");
            Matcher matcher = apiVer.matcher(tim.substring(prefix.length()));
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new AssertionError((Object)("Unexpected toolkit jar name: " + tim));
        }
        throw new AssertionError((Object)("Failed to find a toolkit jar in " + timJars));
    }

    private File createConfigFile(TCSecurityManager securityManager) {
        File tmp;
        String config = this.resolveConfig(securityManager);
        try {
            tmp = File.createTempFile("tc-config", ".xml");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        tmp.deleteOnExit();
        String fName = tmp.getAbsolutePath();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fName, false);
            fos.write(config.getBytes());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StandaloneL1Boot.closeQuietly(fos);
                throw throwable;
            }
        }
        StandaloneL1Boot.closeQuietly(fos);
        return tmp;
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String resolveConfig(TCSecurityManager securityManager) {
        Client clients;
        TcConfigDocument.TcConfig embedded;
        try {
            embedded = this.resolveEmbedded(securityManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TcConfigDocument doc = TcConfigDocument.Factory.newInstance();
        TcConfigDocument.TcConfig newTcConfig = doc.addNewTcConfig();
        Modules modules = newTcConfig.addNewClients().addNewModules();
        ProductInfo info = ProductInfo.getInstance();
        Module module = modules.addNewModule();
        module.setName("terracotta-toolkit-" + this.toolkitApiVersion);
        module.setGroupId("org.terracotta.toolkit");
        if (info.isEnterprise()) {
            module = modules.addNewModule();
            module.setName("terracotta-toolkit-" + this.toolkitApiVersion + "-ee");
            module.setGroupId("org.terracotta.toolkit");
        }
        if ((clients = embedded.getClients()) == null) {
            clients = embedded.addNewClients();
        }
        clients.setModules(modules);
        if (embedded.getServers() != null) {
            newTcConfig.setServers(embedded.getServers());
        }
        if (embedded.getSystem() != null) {
            newTcConfig.setSystem(embedded.getSystem());
        }
        newTcConfig.setClients(clients);
        if (embedded.getTcProperties() != null) {
            newTcConfig.setTcProperties(embedded.getTcProperties());
        }
        return doc.toString();
    }

    private TcConfigDocument.TcConfig resolveEmbedded(TCSecurityManager securityManager) throws ConfigurationSetupException, XmlException {
        String configText;
        if (this.isURLConfig) {
            String embeddedTcConfigURL = URLConfigUtil.translateSystemProperties(this.embeddedTcConfig);
            ConfigurationSpec configurationSpec = new ConfigurationSpec(embeddedTcConfigURL, StandardConfigurationSetupManagerFactory.ConfigMode.EXPRESS_L1, new File("."));
            StandardXMLFileConfigurationCreator creator = new StandardXMLFileConfigurationCreator(configurationSpec, (ConfigBeanFactory)new TerracottaDomainConfigurationDocumentBeanFactory(), (PwProvider)securityManager);
            StandardBeanRepository beanRepo = new StandardBeanRepository(Object.class);
            creator.createConfigurationIntoRepositories((MutableBeanRepository)beanRepo, (MutableBeanRepository)beanRepo, (MutableBeanRepository)beanRepo, (MutableBeanRepository)beanRepo, (ApplicationsRepository)new StandardApplicationsRepository(), true);
            configText = creator.rawConfigText();
        } else {
            configText = this.embeddedTcConfig;
        }
        return TcConfigDocument.Factory.parse((String)configText).getTcConfig();
    }

    @Override
    public Object call() throws Exception {
        if (LicenseManager.getLicense() == null) {
            String licenseLocation = "terracotta-license.key";
            LicenseManager.loadLicenseFromStream((InputStream)this.appLevelTimLoader.getResourceAsStream(licenseLocation), (String)("resource " + licenseLocation));
        }
        TCSecurityManager securityManager = null;
        if (this.securityInfo.isSecure()) {
            if (!ProductInfo.getInstance().isEnterprise()) {
                throw new RuntimeException("You're trying to setup a secured environment, which requires a EE version of Terracotta");
            }
            logger.info((Object)("Secured environment! Enabling SSL & will be authenticating as user '" + this.securityInfo.getUsername() + "'"));
            securityManager = DSOContextImpl.createSecurityManager(this.env);
        }
        File configFile = this.createConfigFile(securityManager);
        DSOContext context = DSOContextImpl.createStandaloneContext((String)configFile.getAbsolutePath(), (ClassLoader)this.appLevelTimLoader, this.virtualTimJars, this.additionalModules, (URL)this.bootJarUrl, (boolean)this.rejoin, securityManager, (SecurityInfo)this.securityInfo);
        return context;
    }

    static {
        ConcurrentMap dummy = new MapMaker().weakValues().makeMap();
        dummy.put("dummy", new Object());
        logger = TCLogging.getLogger(StandaloneL1Boot.class);
    }
}

