/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.terracotta.express.BootjarLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class L1Loader
extends URLClassLoader {
    private final Map<String, byte[]> extraClassDefs;
    private final Set<String> forbiddenTypes;

    public L1Loader(URL[] urls, BootjarLoader bootjarLoader, Map<String, byte[]> extraClassDefs, Set<String> forbiddenTypes) {
        super(urls, (ClassLoader)bootjarLoader);
        this.forbiddenTypes = new HashSet<String>(forbiddenTypes);
        this.extraClassDefs = new HashMap<String, byte[]>(extraClassDefs);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.forbiddenTypes.contains(name)) {
            throw new ClassNotFoundException("FORBIDDEN TYPE: " + name);
        }
        byte[] classBytes = this.extraClassDefs.remove(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }
}

