/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.tc.object.bytecode.ManagerUtil;
import com.terracotta.express.ClientFactoryInternal;
import com.terracotta.express.ClientImpl;
import com.terracotta.express.loader.Handler;
import com.terracotta.express.loader.Jar;
import com.terracotta.express.loader.JarManager;
import com.terracotta.express.loader.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.terracotta.express.Client;

public class ClientFactoryImpl
implements ClientFactoryInternal {
    private static final String TMP_SIGAR_JARS_PREFIX = "tmpSigarJars";
    private static final long CUTOFF_TIME = System.currentTimeMillis() - 86400000L;
    private static final String SKIP_SIGAR_CLEAN_UP_PROPERTY = ClientFactoryImpl.class.getName() + ".SKIP_SIGAR_CLEAN_UP";
    private static final String DEBUG_SIGAR_CLEAN_UP_PROPERTY = ClientFactoryImpl.class.getName() + ".DEBUG_SIGAR_CLEAN_UP";
    private final JarManager jarManager = new JarManager();
    private final Map<String, URL> virtualTimJars = new ConcurrentHashMap<String, URL>();
    private final Map<String, ClientImpl> clientsByUrl = new ConcurrentHashMap<String, ClientImpl>();
    private final URL bootJarUrl;
    private final List<Jar> l1Jars = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<String, Map<String, Object>> envByUrl = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final String SIGAR_LIB_PATH_PROPERTY_NAME = "org.hyperic.sigar.path";
    private static final String BASE_LIBRARY_NAME = ClientFactoryImpl.baseLibraryName();

    public ClientFactoryImpl() {
        ClientFactoryImpl.testForBootJar();
        ClientFactoryImpl.testForWrongTcconfig();
        System.setProperty("tc.active", "true");
        System.setProperty("tc.dso.globalmode", "false");
        try {
            URL source = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String toolkitRuntimeJarName = new File(source.toExternalForm()).getName();
            source = Util.fixUpUrl(source);
            if (!Boolean.getBoolean(SKIP_SIGAR_CLEAN_UP_PROPERTY)) {
                ClientFactoryImpl.cleanupSigarTempFiles(TMP_SIGAR_JARS_PREFIX);
            }
            File sigarTmpDir = ClientFactoryImpl.createTempDir(TMP_SIGAR_JARS_PREFIX);
            boolean isDirectoryUrl = Util.isDirectoryUrl(source);
            if (isDirectoryUrl) {
                File dir = new File(source.toURI());
                File toolkitRuntimeFile = new File(new File(dir, ".."), toolkitRuntimeJarName);
                if (toolkitRuntimeFile.exists() && toolkitRuntimeJarName.endsWith(".jar")) {
                    source = toolkitRuntimeFile.getCanonicalFile().toURL();
                    this.bootJarUrl = this.handleJarUrl(source, sigarTmpDir);
                } else {
                    this.bootJarUrl = this.handleDirectoryUrl(source, sigarTmpDir);
                }
            } else {
                this.bootJarUrl = this.handleJarUrl(source, sigarTmpDir);
            }
            if (this.bootJarUrl == null) {
                throw new NullPointerException("bootJarUrl is null");
            }
            System.setProperty(SIGAR_LIB_PATH_PROPERTY_NAME, sigarTmpDir.getAbsolutePath());
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL handleJarUrl(URL source, File sigarTmpDir) throws IOException, MalformedURLException {
        URL uRL;
        URL bootJar = null;
        ZipInputStream standaloneJar = null;
        try {
            standaloneJar = new ZipInputStream(source.openStream());
            ZipEntry entry = standaloneJar.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("L1") && entry.getName().endsWith(".jar")) {
                    URL l1Jar = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    this.l1Jars.add(this.jarManager.getOrCreate(l1Jar.toExternalForm(), l1Jar));
                } else if (entry.getName().startsWith("TIMs") && entry.getName().endsWith(".jar")) {
                    String baseJar = ClientFactoryImpl.baseName(entry);
                    URL timJarUrl = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    this.jarManager.getOrCreate(timJarUrl.toExternalForm(), timJarUrl);
                    this.virtualTimJars.put(baseJar, this.newTcJarUrl(timJarUrl));
                } else if (entry.getName().equals("dso-boot.jar")) {
                    bootJar = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    this.jarManager.getOrCreate(bootJar.toExternalForm(), bootJar);
                } else if (entry.getName().equals("exported-classes.jar")) {
                    URL exports = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    this.jarManager.getOrCreate(exports.toExternalForm(), exports);
                }
                if (entry.getName().toLowerCase().contains("sigar")) {
                    ClientFactoryImpl.handleSigarZipEntry(standaloneJar, entry, sigarTmpDir);
                }
                entry = standaloneJar.getNextEntry();
            }
            uRL = bootJar;
        }
        catch (Throwable throwable) {
            Util.closeQuietly(standaloneJar);
            throw throwable;
        }
        Util.closeQuietly(standaloneJar);
        return uRL;
    }

    private URL handleDirectoryUrl(URL source, File sigarTmpDir) throws URISyntaxException, MalformedURLException, IOException {
        URL bootJar = null;
        File dir = new File(source.toURI());
        LinkedList<File> list = new LinkedList<File>();
        list.addAll(Arrays.asList(dir.listFiles()));
        while (!list.isEmpty()) {
            File entry = (File)list.remove(0);
            if (entry.isDirectory()) {
                list.addAll(Arrays.asList(entry.listFiles()));
            } else if (entry.getAbsolutePath().contains("L1") && entry.getName().endsWith(".jar")) {
                URL l1Jar = Util.toURL(entry);
                this.l1Jars.add(this.jarManager.getOrCreate(l1Jar.toExternalForm(), l1Jar));
            } else if (entry.getAbsolutePath().contains("TIMs") && entry.getName().endsWith(".jar")) {
                URL timJarUrl = Util.toURL(entry);
                this.jarManager.getOrCreate(timJarUrl.toExternalForm(), timJarUrl);
                this.virtualTimJars.put(entry.getName(), this.newTcJarUrl(timJarUrl));
            } else if (entry.getName().equals("dso-boot.jar")) {
                bootJar = Util.toURL(entry);
                this.jarManager.getOrCreate(bootJar.toExternalForm(), bootJar);
            } else if (entry.getName().equals("exported-classes.jar")) {
                URL exports = Util.toURL(entry);
                this.jarManager.getOrCreate(exports.toExternalForm(), exports);
            }
            if (!entry.getName().toLowerCase().contains("sigar")) continue;
            ClientFactoryImpl.copySigarEntry(entry, sigarTmpDir);
        }
        return bootJar;
    }

    @Override
    public Client createDedicatedClient(String tcConfig, boolean isUrl, Class[] moduleIntrospectionSources) {
        return this.createClient(tcConfig, isUrl, moduleIntrospectionSources, true, false, this.createEnvIfAbsent(tcConfig));
    }

    @Override
    public Client createDedicatedRejoinClient(String tcConfig, boolean isUrl, Class[] moduleIntrospectionSources) {
        return this.createClient(tcConfig, isUrl, moduleIntrospectionSources, true, true, this.createEnvIfAbsent(tcConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getOrCreateClient(String tcConfig, boolean isUrlConfig, Class[] moduleIntrospectionSources) {
        if (!isUrlConfig) {
            return this.createClient(tcConfig, isUrlConfig, moduleIntrospectionSources, null);
        }
        if (tcConfig == null) {
            throw new NullPointerException("null tcConfig");
        }
        ClientImpl client = this.clientsByUrl.get(tcConfig = tcConfig.replaceAll("\\s", ""));
        if (client != null) {
            try {
                client.join(moduleIntrospectionSources);
                return client;
            }
            catch (ClientImpl.ClientShutdownException e) {
                // empty catch block
            }
        }
        String string = tcConfig.intern();
        synchronized (string) {
            Map<String, Object> env;
            client = this.clientsByUrl.get(tcConfig);
            if (client != null) {
                try {
                    client.join(moduleIntrospectionSources);
                    return client;
                }
                catch (ClientImpl.ClientShutdownException e) {
                    // empty catch block
                }
            }
            if ((client = this.createClient(tcConfig, isUrlConfig, moduleIntrospectionSources, env = this.createEnvIfAbsent(tcConfig))).isDedicatedClient()) {
                throw new AssertionError((Object)"should not be a dedicated client here");
            }
            this.clientsByUrl.put(tcConfig, client);
            return client;
        }
    }

    private Map<String, Object> createEnvIfAbsent(String tcConfig) {
        Map<String, Object> previous;
        Map<String, Object> env = (Map<String, Object>)this.envByUrl.get(tcConfig);
        if (env == null) {
            env = this.createNewEnv();
        }
        if ((previous = this.envByUrl.putIfAbsent(tcConfig, env)) != null) {
            env = previous;
        }
        return env;
    }

    private Map<String, Object> createNewEnv() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        String secretProviderClass = System.getProperty("com.terracotta.express.SecretProvider");
        if (secretProviderClass != null) {
            Object instance = ClientFactoryImpl.newInstance(secretProviderClass);
            try {
                instance.getClass().getMethod("fetchSecret", new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't invoke fetchSecret on " + secretProviderClass);
            }
            env.put("com.terracotta.express.SecretProvider", instance);
        }
        return env;
    }

    private static <T> T newInstance(String secretProviderClass) {
        try {
            return (T)Class.forName(secretProviderClass).newInstance();
        }
        catch (InstantiationException e) {
            throw ClientFactoryImpl.createRuntimeException("instantiate an object of class", secretProviderClass, e);
        }
        catch (IllegalAccessException e) {
            throw ClientFactoryImpl.createRuntimeException("load or instantiate class", secretProviderClass, e);
        }
        catch (ClassNotFoundException e) {
            throw ClientFactoryImpl.createRuntimeException("load class", secretProviderClass, e);
        }
    }

    private static RuntimeException createRuntimeException(String msg, String secretProviderClass, Exception e) {
        return new RuntimeException(String.format("SecretProvider initialization: Couldn't %s \"%s\" (Check the value of property \"%s\" or your classpath)", msg, secretProviderClass, "com.terracotta.express.SecretProvider"), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ClientImpl clientImpl, String tcConfig, boolean isUrlConfig) {
        if (clientImpl.isDedicatedClient()) {
            return;
        }
        if (isUrlConfig) {
            String string = tcConfig.intern();
            synchronized (string) {
                this.envByUrl.remove(tcConfig);
                ClientImpl removed = this.clientsByUrl.remove(tcConfig);
                if (removed != clientImpl) {
                    throw new AssertionError((Object)("removed: " + removed + " for " + tcConfig));
                }
            }
        }
    }

    private ClientImpl createClient(String tcConfig, boolean isUrlConfig, Class[] moduleIntrospectionSources, Map<String, Object> env) {
        return this.createClient(tcConfig, isUrlConfig, moduleIntrospectionSources, false, false, env);
    }

    private ClientImpl createClient(String tcConfig, boolean isUrlConfig, Class[] moduleIntrospectionSources, boolean dedicatedClient, boolean rejoinClient, Map<String, Object> env) {
        ArrayList<URL> timJars = new ArrayList<URL>();
        for (Map.Entry<String, URL> entry : this.virtualTimJars.entrySet()) {
            if (!entry.getKey().startsWith("tim-") && !entry.getKey().startsWith("terracotta-toolkit")) continue;
            timJars.add(entry.getValue());
        }
        return this.newClient(tcConfig, isUrlConfig, timJars, moduleIntrospectionSources, dedicatedClient, rejoinClient, env);
    }

    private ClientImpl newClient(String tcConfig, boolean isUrlConfig, List<URL> timJars, Class[] moduleIntrospectionSources, boolean dedicatedClient, boolean rejoinClient, Map<String, Object> env) {
        ClientImpl client = new ClientImpl(tcConfig, isUrlConfig, this.jarManager, timJars.toArray(new URL[0]), this.getClass().getClassLoader(), this.virtualTimJars, this.l1Jars, this.bootJarUrl, moduleIntrospectionSources, this, dedicatedClient, rejoinClient, env);
        return client;
    }

    private static void handleSigarZipEntry(ZipInputStream agentJar, ZipEntry entry, File sigarTmpDir) throws IOException {
        if (BASE_LIBRARY_NAME != null && entry.getName().contains(BASE_LIBRARY_NAME)) {
            ClientFactoryImpl.extractSigarZipEntry(agentJar, entry, sigarTmpDir);
        }
    }

    private static void extractSigarZipEntry(ZipInputStream jar, ZipEntry entry, File outputDir) throws IOException {
        byte[] content = ClientFactoryImpl.getCurrentZipEntry(jar);
        String outName = ClientFactoryImpl.baseName(entry);
        File outFile = new File(outputDir, outName);
        ClientFactoryImpl.writeFile(outFile, content);
        outFile.deleteOnExit();
    }

    private static void copySigarEntry(File sourceFile, File destDir) throws IOException {
        File destFile = new File(destDir, sourceFile.getName());
        Util.copyFile(sourceFile, destFile);
        destFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, byte[] contents) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(contents);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] getCurrentZipEntry(ZipInputStream zis) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((n = zis.read(buf, 0, 1024)) > -1) {
            bout.write(buf, 0, n);
        }
        bout.close();
        return bout.toByteArray();
    }

    private static File createTempDir(String prefix) throws IOException {
        File tempDir = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    private static void cleanupSigarTempFiles(final String prefix) {
        block7: {
            boolean debugCleanup = Boolean.getBoolean(DEBUG_SIGAR_CLEAN_UP_PROPERTY);
            try {
                File tmpFile = File.createTempFile(prefix, ".tmp");
                File tempDir = tmpFile.getParentFile();
                tmpFile.delete();
                File[] sigarTemps = tempDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                if (debugCleanup) {
                    System.err.println("Clean up CUTOFF_TIME: " + new Date(CUTOFF_TIME));
                }
                for (File sigarTemp : sigarTemps) {
                    if (!sigarTemp.isDirectory() || sigarTemp.lastModified() >= CUTOFF_TIME) continue;
                    if (debugCleanup) {
                        System.err.println("Deleting folder " + sigarTemp + " with lastModifiedTime " + new Date(sigarTemp.lastModified()));
                    }
                    try {
                        ClientFactoryImpl.deleteDirectory(sigarTemp);
                    }
                    catch (IOException e) {
                        if (!debugCleanup) continue;
                        System.err.println("Error deleting temp dir: " + sigarTemp);
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                if (!debugCleanup) break block7;
                System.err.println("Error deleting sigar temp dir");
                e.printStackTrace();
            }
        }
    }

    public static void deleteDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ClientFactoryImpl.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("Unable to delete file " + file);
            }
        }
        if (!dir.delete()) {
            throw new IOException("Unable to delete directory " + dir);
        }
    }

    private static void testForBootJar() {
        try {
            Class<?> c = Class.forName(ManagerUtil.class.getName());
            if (c.getClassLoader() == null) {
                throw new RuntimeException("The Terracotta dso-boot.jar is specified via -Xbootclasspath. This is not a correct configuration, please remove it");
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static void testForWrongTcconfig() {
        String tcConfigValue = System.getProperty("tc.config");
        if (tcConfigValue != null) {
            throw new RuntimeException("The Terracotta config file should not be set through -Dtc.config in this usage.");
        }
    }

    private static String baseName(ZipEntry entry) {
        return new File(entry.getName()).getName();
    }

    private URL newTcJarUrl(URL embedded) {
        try {
            return new URL("tcjar", "", -1, "__TC__" + embedded.toExternalForm() + "__TC__" + "/", new Handler(this.jarManager));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String baseLibraryName() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        String majorVersion = version.substring(0, 1);
        StringBuffer buf = new StringBuffer();
        if (arch.endsWith("86")) {
            arch = "x86";
        }
        if (name.equals("Linux")) {
            buf.append(arch).append("-linux");
        } else if (name.indexOf("Windows") > -1) {
            buf.append(arch).append("-winnt");
        } else if (name.equals("SunOS")) {
            if (arch.startsWith("sparcv") && "64".equals(System.getProperty("sun.arch.data.model"))) {
                arch = "sparc64";
            }
            buf.append(arch).append("-solaris");
        } else if (name.equals("HP-UX")) {
            arch = arch.startsWith("IA64") ? "ia64" : "pa";
            if (version.indexOf("11") > -1) {
                buf.append(arch).append("-hpux-11");
            }
        } else if (name.equals("AIX")) {
            buf.append("ppc-aix-").append(majorVersion);
        } else if (name.equals("Mac OS X")) {
            buf.append("universal-macosx");
        } else if (name.equals("FreeBSD")) {
            buf.append(arch).append("-freebsd-").append(majorVersion);
        } else if (name.equals("OpenBSD")) {
            buf.append(arch).append("-openbsd-").append(majorVersion);
        } else if (name.equals("NetBSD")) {
            buf.append(arch).append("-netbsd-").append(majorVersion);
        } else if (name.equals("OSF1")) {
            buf.append("alpha-osf1-").append(majorVersion);
        } else if (name.equals("NetWare")) {
            buf.append("x86-netware-").append(majorVersion);
        }
        if (buf.length() == 0) {
            return null;
        }
        String prefix = "libsigar-";
        if (name.startsWith("Windows")) {
            prefix = "sigar-";
        }
        return prefix + buf.toString();
    }
}

