/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.Map;
import org.tio.utils.qr.scheme.Schema;
import org.tio.utils.qr.scheme.SchemeUtil;

public class EMail
extends Schema {
    private static final String MAILTO = "mailto";
    private String email;

    public EMail() {
    }

    public EMail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.toLowerCase().startsWith(MAILTO)) {
            throw new IllegalArgumentException("this is not a valid email code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.toLowerCase());
        if (parameters.containsKey(MAILTO)) {
            this.setEmail(parameters.get(MAILTO));
        }
        return this;
    }

    @Override
    public String generateString() {
        return "mailto:" + this.email;
    }

    public static EMail parse(String emailCode) {
        EMail mail = new EMail();
        mail.parseSchema(emailCode);
        return mail;
    }

    public String toString() {
        return this.generateString();
    }
}

