/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.ObjWithLock;

public class ListWithLock<T>
extends ObjWithLock<List<T>> {
    private static final long serialVersionUID = 8549668315606224029L;
    private static final Logger log = LoggerFactory.getLogger(ListWithLock.class);

    public ListWithLock(List<T> list) {
        super(list);
    }

    public ListWithLock(List<T> list, ReentrantReadWriteLock lock) {
        super(list, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getLock().writeLock();
        writeLock.lock();
        try {
            List list = (List)this.getObj();
            boolean bl = list.add(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.getLock().writeLock();
        writeLock.lock();
        try {
            List list = (List)this.getObj();
            list.clear();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getLock().writeLock();
        writeLock.lock();
        try {
            List list = (List)this.getObj();
            boolean bl = list.remove(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.getLock().readLock();
        readLock.lock();
        try {
            List list = (List)this.getObj();
            int n = list.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }
}

