/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.caffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.caffeine.DefaultRemovalListener;

public class CaffeineUtils {
    private static Logger log = LoggerFactory.getLogger(CaffeineUtils.class);

    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats) {
        return CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, null);
    }

    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats, RemovalListener<K, V> removalListener) {
        if (removalListener == null) {
            removalListener = new DefaultRemovalListener(cacheName);
        }
        Caffeine cacheBuilder = Caffeine.newBuilder().removalListener(removalListener);
        if (timeToLiveSeconds != null && timeToLiveSeconds > 0L) {
            cacheBuilder.expireAfterWrite(timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (timeToIdleSeconds != null && timeToIdleSeconds > 0L) {
            cacheBuilder.expireAfterAccess(timeToIdleSeconds.longValue(), TimeUnit.SECONDS);
        }
        cacheBuilder.initialCapacity(initialCapacity.intValue());
        cacheBuilder.maximumSize((long)maximumSize.intValue());
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        LoadingCache loadingCache = cacheBuilder.build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return null;
            }
        });
        return loadingCache;
    }

    public static void main(String[] args) throws Exception {
        Long timeToLiveSeconds = 1L;
        Long timeToIdleSeconds = null;
        Integer initialCapacity = 10;
        Integer maximumSize = 1000;
        boolean recordStats = false;
        LoadingCache loadingCache = CaffeineUtils.createLoadingCache("testCachename", timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats);
        loadingCache.put((Object)"1", (Object)"11111");
        Object o = loadingCache.get((Object)"1");
        TimeUnit.SECONDS.sleep(3L);
        loadingCache.put((Object)"2", (Object)"2222");
        o = loadingCache.getIfPresent((Object)"1");
        System.out.println(o);
        o = loadingCache.getIfPresent((Object)"2");
        System.out.println(o);
    }
}

