/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.quartz;

import com.xiaoleilu.hutool.date.DateUtil;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SystemTimer;

public abstract class AbstractJobWihLog
implements Job {
    private Logger log = LoggerFactory.getLogger(AbstractJobWihLog.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.log.info("\u5b9a\u65f6\u4efb\u52a1[{}]\u8fd0\u884c\u5f00\u59cb\uff0c \u672c\u6b21id:{}, \u672c\u6b21\u6267\u884c\u65f6\u95f4:{}, \u4e0a\u6b21\u6267\u884c\u65f6\u95f4:{}, \u4e0b\u6b21\u6267\u884c\u65f6\u95f4:{}", new Object[]{this.getClass().getName(), context.getFireInstanceId(), DateUtil.formatDateTime((Date)context.getFireTime()), DateUtil.formatDateTime((Date)context.getPreviousFireTime()), DateUtil.formatDateTime((Date)context.getNextFireTime())});
        long start = SystemTimer.currentTimeMillis();
        try {
            this.run(context);
        }
        catch (JobExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error(e.toString(), e);
        }
        long end = SystemTimer.currentTimeMillis();
        long iv = end - start;
        this.log.info("\u5b9a\u65f6\u4efb\u52a1[{}]\u8fd0\u884c\u5b8c\u6bd5\uff0c \u672c\u6b21id:{}, \u672c\u6b21\u6267\u884c\u65f6\u95f4:{}, \u8017\u65f6:{}ms", new Object[]{this.getClass().getName(), context.getFireInstanceId(), DateUtil.formatDateTime((Date)context.getFireTime()), iv});
    }

    public abstract void run(JobExecutionContext var1) throws Exception;

    public static void main(String[] args) {
    }
}

