/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.ip.path;

import com.xiaoleilu.hutool.date.BetweenFormater;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.tio.http.server.stat.ip.path.IpPathAccessStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class IpAccessStat
implements Serializable {
    private static final long serialVersionUID = 5314797979230623121L;
    private MapWithLock<String, IpPathAccessStat> ipPathAccessStatMap = new MapWithLock(new HashMap());
    private Long durationType;
    public final SetWithLock<String> sessionIds = new SetWithLock(new HashSet());
    private long duration;
    private String ip;
    private long firstAccessTime = SystemTimer.currentTimeMillis();
    private long lastAccessTime = SystemTimer.currentTimeMillis();
    public final AtomicInteger count = new AtomicInteger();
    public final AtomicInteger noSessionCount = new AtomicInteger();

    public long getDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public IpPathAccessStat get(String path) {
        return this.get(path, true);
    }

    public IpPathAccessStat get(String path, boolean forceCreate) {
        if (path == null) {
            return null;
        }
        IpPathAccessStat ipPathAccessStat = (IpPathAccessStat)this.ipPathAccessStatMap.get((Object)path);
        if (ipPathAccessStat == null && forceCreate) {
            ipPathAccessStat = (IpPathAccessStat)this.ipPathAccessStatMap.putIfAbsent((Object)path, (Object)new IpPathAccessStat(this.durationType, this.ip, path));
        }
        return ipPathAccessStat;
    }

    public IpAccessStat(Long durationType, String ip) {
        this.durationType = durationType;
        this.ip = ip;
    }

    public MapWithLock<String, IpPathAccessStat> getIpPathAccessStatMap() {
        return this.ipPathAccessStatMap;
    }

    public void setIpPathAccessStatMap(MapWithLock<String, IpPathAccessStat> ipPathAccessStatMap) {
        this.ipPathAccessStatMap = ipPathAccessStatMap;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public double getPerSecond() {
        int count = this.count.get();
        long duration = this.getDuration();
        double perSecond = (double)count / (double)duration * 1000.0;
        return perSecond;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public void setFirstAccessTime(long firstAccessTime) {
        this.firstAccessTime = firstAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }
}

