/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.mvc;

import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.xiaoleilu.hutool.util.ArrayUtil;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.server.annotation.RequestPath;
import org.tio.utils.json.Json;

public class Routes {
    private static Logger log = LoggerFactory.getLogger(Routes.class);
    public Map<String, Object> pathBeanMap = new TreeMap<String, Object>();
    public Map<String, Class<?>> pathClassMap = new TreeMap();
    public Map<Class<?>, String> classPathMap = new HashMap();
    public Map<String, Method> pathMethodMap = new TreeMap<String, Method>();
    public Map<String, String> pathMethodstrMap = new TreeMap<String, String>();
    public Map<Method, String[]> methodParamnameMap = new HashMap<Method, String[]>();
    public Map<Method, Object> methodBeanMap = new HashMap<Method, Object>();

    private static String formateBeanPath(String initPath) {
        return initPath;
    }

    private static String formateMethodPath(String initPath) {
        return initPath;
    }

    public static void main(String[] args) {
    }

    public Routes(String[] scanPackages) {
        if (scanPackages != null) {
            FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(scanPackages);
            fastClasspathScanner.matchClassesWithAnnotation(RequestPath.class, new ClassAnnotationMatchProcessor(){

                public void processMatch(Class<?> classWithAnnotation) {
                    try {
                        Object bean = classWithAnnotation.newInstance();
                        RequestPath mapping = classWithAnnotation.getAnnotation(RequestPath.class);
                        String beanPath = mapping.value();
                        beanPath = Routes.formateBeanPath(beanPath);
                        Object obj = Routes.this.pathBeanMap.get(beanPath);
                        if (obj != null) {
                            log.error("mapping[{}] already exists in class [{}]", (Object)beanPath, (Object)obj.getClass().getName());
                        } else {
                            Routes.this.pathBeanMap.put(beanPath, bean);
                            Routes.this.pathClassMap.put(beanPath, classWithAnnotation);
                            Routes.this.classPathMap.put(classWithAnnotation, beanPath);
                        }
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            });
            fastClasspathScanner.matchClassesWithMethodAnnotation(RequestPath.class, new MethodAnnotationMatchProcessor(){

                public void processMatch(Class<?> matchingClass, Executable matchingMethodOrConstructor) {
                    RequestPath mapping = matchingMethodOrConstructor.getAnnotation(RequestPath.class);
                    String methodName = matchingMethodOrConstructor.getName();
                    String methodPath = mapping.value();
                    methodPath = Routes.formateMethodPath(methodPath);
                    String beanPath = Routes.this.classPathMap.get(matchingClass);
                    if (StringUtils.isBlank((CharSequence)beanPath)) {
                        log.error("\u65b9\u6cd5\u6709\u6ce8\u89e3\uff0c\u4f46\u7c7b\u6ca1\u6ce8\u89e3, method:{}, class:{}", (Object)methodName, matchingClass);
                        return;
                    }
                    Object bean = Routes.this.pathBeanMap.get(beanPath);
                    String completeMethodPath = methodPath;
                    if (beanPath != null) {
                        completeMethodPath = beanPath + methodPath;
                    }
                    Class<?>[] parameterTypes = matchingMethodOrConstructor.getParameterTypes();
                    try {
                        Method method = matchingClass.getMethod(methodName, parameterTypes);
                        BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
                        Object[] parameterNames = paranamer.lookupParameterNames((AccessibleObject)method, false);
                        Method checkMethod = Routes.this.pathMethodMap.get(completeMethodPath);
                        if (checkMethod != null) {
                            log.error("mapping[{}] already exists in method [{}]", (Object)completeMethodPath, (Object)(checkMethod.getDeclaringClass() + "#" + checkMethod.getName()));
                            return;
                        }
                        Routes.this.pathMethodMap.put(completeMethodPath, method);
                        Routes.this.pathMethodstrMap.put(completeMethodPath, matchingClass.getName() + "." + method.getName() + "(" + ArrayUtil.join((Object[])parameterNames, (CharSequence)",") + ")");
                        Routes.this.methodParamnameMap.put(method, (String[])parameterNames);
                        Routes.this.methodBeanMap.put(method, bean);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            });
            fastClasspathScanner.scan();
            log.info("class  mapping\r\n{}", (Object)Json.toFormatedJson(this.pathClassMap));
            log.info("method mapping\r\n{}", (Object)Json.toFormatedJson(this.pathMethodstrMap));
        }
    }
}

