/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.handler;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.server.intf.ServerAioHandler;

public abstract class AbstractHttpServerAioHandler
implements ServerAioHandler,
HttpRequestHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractHttpServerAioHandler.class);
    protected HttpConfig httpConfig;
    protected Routes routes = null;

    public static void main(String[] args) {
    }

    public AbstractHttpServerAioHandler() {
    }

    public AbstractHttpServerAioHandler(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public AbstractHttpServerAioHandler(HttpConfig httpConfig, Routes routes) {
        this(httpConfig);
        this.routes = routes;
    }

    public HttpRequest decode(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (ChannelContext)channelContext);
        return request;
    }

    public ByteBuffer encode(Packet packet, GroupContext groupContext, ChannelContext channelContext) {
        HttpResponse httpResponse = (HttpResponse)packet;
        ByteBuffer byteBuffer = HttpResponseEncoder.encode((HttpResponse)httpResponse, (GroupContext)groupContext, (ChannelContext)channelContext, (boolean)false);
        return byteBuffer;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        HttpRequest request = (HttpRequest)packet;
        HttpResponse httpResponse = this.handler(request);
        Aio.send((ChannelContext)channelContext, (Packet)httpResponse);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

