/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.TioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import org.tio.http.server.HttpServerAioHandler;
import org.tio.http.server.HttpServerAioListener;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.HttpSessionListener;
import org.tio.http.server.mvc.Routes;
import org.tio.server.AioServer;
import org.tio.server.ServerGroupContext;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.guava.GuavaCache;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class HttpServerStarter {
    private static Logger log = LoggerFactory.getLogger(HttpServerStarter.class);
    private HttpConfig httpConfig = null;
    private HttpServerAioHandler httpServerAioHandler = null;
    private HttpServerAioListener httpServerAioListener = null;
    private ServerGroupContext serverGroupContext = null;
    private AioServer aioServer = null;
    private HttpRequestHandler httpRequestHandler;

    public static void main(String[] args) throws IOException {
    }

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this(httpConfig, requestHandler, null, null);
    }

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.init(httpConfig, requestHandler, tioExecutor, groupExecutor);
    }

    public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor) throws IOException {
        this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, null, null, null);
    }

    public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, ICache sessionStore) throws IOException {
        this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, sessionStore, null, null);
    }

    public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, ICache sessionStore, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, null, sessionStore, tioExecutor, groupExecutor);
    }

    public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, HttpSessionListener httpSessionListener, ICache sessionStore, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        int port = serverPort;
        this.httpConfig = new HttpConfig(Integer.valueOf(port), null, contextPath, null);
        this.httpConfig.setPageRoot(pageRoot);
        if (sessionStore != null) {
            this.httpConfig.setSessionStore(sessionStore);
        }
        Routes routes = new Routes(scanPackages);
        DefaultHttpRequestHandler requestHandler = new DefaultHttpRequestHandler(this.httpConfig, routes);
        requestHandler.setHttpServerInterceptor(httpServerInterceptor);
        requestHandler.setHttpSessionListener(httpSessionListener);
        this.init(this.httpConfig, requestHandler, tioExecutor, groupExecutor);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public HttpServerAioHandler getHttpServerAioHandler() {
        return this.httpServerAioHandler;
    }

    public HttpServerAioListener getHttpServerAioListener() {
        return this.httpServerAioListener;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    private void init(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.httpConfig = httpConfig;
        this.httpRequestHandler = requestHandler;
        httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.httpServerAioHandler = new HttpServerAioHandler(httpConfig, requestHandler);
        this.httpServerAioListener = new HttpServerAioListener();
        this.serverGroupContext = new ServerGroupContext((ServerAioHandler)this.httpServerAioHandler, (ServerAioListener)this.httpServerAioListener, tioExecutor, groupExecutor);
        this.serverGroupContext.setHeartbeatTimeout(20000L);
        this.serverGroupContext.setShortConnection(true);
        this.serverGroupContext.setAttribute("TIO_HTTP_SERVER_CONFIG", (Object)httpConfig);
        this.serverGroupContext.setName("Tio Http Server");
        this.aioServer = new AioServer(this.serverGroupContext);
        HttpUuid imTioUuid = new HttpUuid();
        this.serverGroupContext.setTioUuid((TioUuid)imTioUuid);
    }

    public void setHttpRequestHandler(HttpRequestHandler requestHandler) {
        this.httpRequestHandler = requestHandler;
    }

    public void start() throws IOException {
        if (this.httpConfig.getSessionStore() == null) {
            GuavaCache guavaCache = GuavaCache.register((String)this.httpConfig.getSessionCacheName(), null, (Long)this.httpConfig.getSessionTimeout());
            this.httpConfig.setSessionStore((ICache)guavaCache);
        }
        if (this.httpConfig.getSessionIdGenerator() == null) {
            this.httpConfig.setSessionIdGenerator((ISessionIdGenerator)UUIDSessionIdGenerator.instance);
        }
        this.aioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort().intValue());
    }

    public void stop() throws IOException {
        this.aioServer.stop();
    }
}

