/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.KeyValue;

public class HttpResponseEncoder {
    private static Logger log = LoggerFactory.getLogger(HttpResponseEncoder.class);
    public static final int MAX_HEADER_LENGTH = 20480;

    public static ByteBuffer encode(HttpResponse httpResponse, GroupContext groupContext, ChannelContext channelContext, boolean skipCookie) {
        List<Cookie> cookies;
        byte[] encodedBytes = httpResponse.getEncodedBytes();
        if (encodedBytes != null) {
            ByteBuffer ret = ByteBuffer.wrap(encodedBytes);
            ret.position(ret.limit());
            return ret;
        }
        int bodyLength = 0;
        byte[] body = httpResponse.getBody();
        if (body != null) {
            bodyLength = body.length;
        }
        StringBuilder sb = new StringBuilder(256);
        HttpResponseStatus httpResponseStatus = httpResponse.getStatus();
        sb.append("HTTP/1.1 ").append(httpResponseStatus.getStatus()).append(" ").append(httpResponseStatus.getDescription()).append("\r\n");
        Map<String, String> headers = httpResponse.getHeaders();
        if (headers != null && headers.size() > 0) {
            headers.put(HttpConst.ResponseHeaderKey.Content_Length, bodyLength + "");
            Set<Map.Entry<String, String>> set = headers.entrySet();
            for (Map.Entry entry : set) {
                sb.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n");
            }
        }
        if (!skipCookie && (cookies = httpResponse.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                sb.append(HttpConst.ResponseHeaderKey.Set_Cookie).append(": ");
                sb.append(cookie.toString());
                sb.append("\r\n");
                if (!log.isInfoEnabled()) continue;
                log.info("{}, set-cookie:{}", (Object)channelContext, (Object)cookie.toString());
            }
        }
        sb.append("\r\n");
        byte[] headerBytes = null;
        try {
            String headerString = sb.toString();
            httpResponse.setHeaderString(headerString);
            headerBytes = headerString.getBytes(httpResponse.getCharset());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(headerBytes.length + bodyLength);
        buffer.put(headerBytes);
        if (bodyLength > 0) {
            buffer.put(body);
        }
        return buffer;
    }

    public static void main(String[] args) {
    }

    public static KeyValue parseHeaderLine(String line) {
        KeyValue keyValue = new KeyValue();
        int p = line.indexOf(":");
        if (p == -1) {
            keyValue.setKey(line);
            return keyValue;
        }
        String name = line.substring(0, p).trim();
        String value = line.substring(p + 1).trim();
        keyValue.setKey(name);
        keyValue.setValue(value);
        return keyValue;
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

