/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpPacket;
import org.tio.http.common.RequestLine;
import org.tio.http.common.session.HttpSession;
import org.tio.http.common.utils.IpUtils;

public class HttpRequest
extends HttpPacket {
    private static final long serialVersionUID = -3849253977016967211L;
    private RequestLine requestLine = null;
    private Map<String, Object[]> params = null;
    private List<Cookie> cookies = null;
    private Map<String, Cookie> cookieMap = null;
    private int contentLength;
    private String bodyString;
    private HttpConst.RequestBodyFormat bodyFormat;
    private String charset = "utf-8";
    private Boolean isAjax = null;
    private Boolean isSupportGzip = null;
    private HttpSession httpSession;
    private Node remote = null;
    private ChannelContext channelContext;
    private HttpConfig httpConfig;
    private String domain = null;
    private String host = null;
    private String clientIp = null;

    public static void main(String[] args) {
    }

    public HttpRequest(Node remote) {
        this.remote = remote;
    }

    public void addParam(String key, Object value) {
        Object[] existValue;
        if (this.params == null) {
            this.params = new HashMap<String, Object[]>();
        }
        if ((existValue = this.params.get(key)) != null) {
            Object[] newExistValue = new Object[existValue.length + 1];
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = value;
            this.params.put(key, newExistValue);
        } else {
            Object[] newExistValue = new Object[]{value};
            this.params.put(key, newExistValue);
        }
    }

    public HttpConst.RequestBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public String getUserAgent() {
        return (String)this.headers.get(HttpConst.RequestHeaderKey.User_Agent);
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = (String)this.headers.get(HttpConst.RequestHeaderKey.Host);
        return this.host;
    }

    public String getClientIp() {
        if (this.clientIp == null) {
            this.clientIp = IpUtils.getRealIp(this);
        }
        return this.clientIp;
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        if (StrUtil.isBlank((CharSequence)this.getHost())) {
            return null;
        }
        this.domain = StrUtil.subBefore((CharSequence)this.getHost(), (CharSequence)":", (boolean)false);
        return this.domain;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Cookie getCookie(String cooiename) {
        if (this.cookieMap == null) {
            return null;
        }
        return this.cookieMap.get(cooiename);
    }

    public Map<String, Cookie> getCookieMap() {
        return this.cookieMap;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public Boolean getIsAjax() {
        if (this.isAjax == null) {
            String X_Requested_With = this.getHeader(HttpConst.RequestHeaderKey.X_Requested_With);
            this.isAjax = X_Requested_With != null && "XMLHttpRequest".equalsIgnoreCase(X_Requested_With) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isAjax;
    }

    public Boolean getIsSupportGzip() {
        if (this.isSupportGzip == null) {
            Object[] ss;
            String Accept_Encoding = this.getHeader(HttpConst.RequestHeaderKey.Accept_Encoding);
            this.isSupportGzip = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Accept_Encoding}) ? (ArrayUtil.contains((Object[])(ss = StringUtils.split((String)Accept_Encoding, (String)",")), (Object)"gzip") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(true);
        }
        return this.isSupportGzip;
    }

    public Map<String, Object[]> getParams() {
        return this.params;
    }

    public String getParam(String name) {
        if (this.params == null) {
            return null;
        }
        Object[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            Object obj = values[0];
            return (String)obj;
        }
        return null;
    }

    public Node getRemote() {
        return this.remote;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public String logstr() {
        String str = "\r\n\u8bf7\u6c42ID_" + this.getId() + "\r\n" + this.getHeaderString();
        if (null != this.getBodyString()) {
            str = str + this.getBodyString();
        }
        return str;
    }

    public void parseCookie() {
        String cookieline = (String)this.headers.get(HttpConst.RequestHeaderKey.Cookie);
        if (StringUtils.isNotBlank((CharSequence)cookieline)) {
            this.cookies = new ArrayList<Cookie>();
            this.cookieMap = new HashMap<String, Cookie>();
            Map<String, String> _cookiemap = Cookie.getEqualMap(cookieline);
            ArrayList<HashMap<String, String>> cookieListMap = new ArrayList<HashMap<String, String>>();
            for (Map.Entry<String, String> cookieMapEntry : _cookiemap.entrySet()) {
                HashMap<String, String> cookieOneMap = new HashMap<String, String>();
                cookieOneMap.put(cookieMapEntry.getKey(), cookieMapEntry.getValue());
                cookieListMap.add(cookieOneMap);
                Cookie cookie = Cookie.buildCookie(cookieOneMap);
                this.cookies.add(cookie);
                this.cookieMap.put(cookie.getName(), cookie);
            }
        }
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBodyFormat(HttpConst.RequestBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public void setBodyString(String bodyString) {
        this.bodyString = bodyString;
    }

    public void setChannelContext(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setCookieMap(Map<String, Cookie> cookieMap) {
        this.cookieMap = cookieMap;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        if (headers != null) {
            this.parseCookie();
        }
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setIsAjax(Boolean isAjax) {
        this.isAjax = isAjax;
    }

    public void setIsSupportGzip(Boolean isSupportGzip) {
        this.isSupportGzip = isSupportGzip;
    }

    public void setParams(Map<String, Object[]> params) {
        this.params = params;
    }

    public void setRemote(Node remote) {
        this.remote = remote;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }
}

